@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.evidently.kotlin.inputs

import com.pulumi.aws.evidently.inputs.LaunchScheduledSplitsConfigStepSegmentOverrideArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * @property evaluationOrder Specifies a number indicating the order to use to evaluate segment overrides, if there are more than one. Segment overrides with lower numbers are evaluated first.
 * @property segment The name or ARN of the segment to use.
 * @property weights The traffic allocation percentages among the feature variations to assign to this segment. This is a set of key-value pairs. The keys are variation names. The values represent the amount of traffic to allocate to that variation for this segment. This is expressed in thousandths of a percent, so a weight of 50000 represents 50% of traffic.
 */
public data class LaunchScheduledSplitsConfigStepSegmentOverrideArgs(
    public val evaluationOrder: Output<Int>,
    public val segment: Output<String>,
    public val weights: Output<Map<String, Int>>,
) :
    ConvertibleToJava<com.pulumi.aws.evidently.inputs.LaunchScheduledSplitsConfigStepSegmentOverrideArgs> {
    override fun toJava(): com.pulumi.aws.evidently.inputs.LaunchScheduledSplitsConfigStepSegmentOverrideArgs =
        com.pulumi.aws.evidently.inputs.LaunchScheduledSplitsConfigStepSegmentOverrideArgs.builder()
            .evaluationOrder(evaluationOrder.applyValue({ args0 -> args0 }))
            .segment(segment.applyValue({ args0 -> args0 }))
            .weights(
                weights.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [LaunchScheduledSplitsConfigStepSegmentOverrideArgs].
 */
@PulumiTagMarker
public class LaunchScheduledSplitsConfigStepSegmentOverrideArgsBuilder internal constructor() {
    private var evaluationOrder: Output<Int>? = null

    private var segment: Output<String>? = null

    private var weights: Output<Map<String, Int>>? = null

    /**
     * @param value Specifies a number indicating the order to use to evaluate segment overrides, if there are more than one. Segment overrides with lower numbers are evaluated first.
     */
    @JvmName("doglvgmmkpxycwxt")
    public suspend fun evaluationOrder(`value`: Output<Int>) {
        this.evaluationOrder = value
    }

    /**
     * @param value The name or ARN of the segment to use.
     */
    @JvmName("wyrwfabnobaiknol")
    public suspend fun segment(`value`: Output<String>) {
        this.segment = value
    }

    /**
     * @param value The traffic allocation percentages among the feature variations to assign to this segment. This is a set of key-value pairs. The keys are variation names. The values represent the amount of traffic to allocate to that variation for this segment. This is expressed in thousandths of a percent, so a weight of 50000 represents 50% of traffic.
     */
    @JvmName("jbbepwromtvrbxew")
    public suspend fun weights(`value`: Output<Map<String, Int>>) {
        this.weights = value
    }

    /**
     * @param value Specifies a number indicating the order to use to evaluate segment overrides, if there are more than one. Segment overrides with lower numbers are evaluated first.
     */
    @JvmName("dsixvhefslxipdwg")
    public suspend fun evaluationOrder(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.evaluationOrder = mapped
    }

    /**
     * @param value The name or ARN of the segment to use.
     */
    @JvmName("gfuwbhfnnwwtkhks")
    public suspend fun segment(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.segment = mapped
    }

    /**
     * @param value The traffic allocation percentages among the feature variations to assign to this segment. This is a set of key-value pairs. The keys are variation names. The values represent the amount of traffic to allocate to that variation for this segment. This is expressed in thousandths of a percent, so a weight of 50000 represents 50% of traffic.
     */
    @JvmName("mokkjyxiuygdbadw")
    public suspend fun weights(`value`: Map<String, Int>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.weights = mapped
    }

    /**
     * @param values The traffic allocation percentages among the feature variations to assign to this segment. This is a set of key-value pairs. The keys are variation names. The values represent the amount of traffic to allocate to that variation for this segment. This is expressed in thousandths of a percent, so a weight of 50000 represents 50% of traffic.
     */
    @JvmName("muuvdkbfhvtmrpid")
    public fun weights(vararg values: Pair<String, Int>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.weights = mapped
    }

    internal fun build(): LaunchScheduledSplitsConfigStepSegmentOverrideArgs =
        LaunchScheduledSplitsConfigStepSegmentOverrideArgs(
            evaluationOrder = evaluationOrder ?: throw PulumiNullFieldException("evaluationOrder"),
            segment = segment ?: throw PulumiNullFieldException("segment"),
            weights = weights ?: throw PulumiNullFieldException("weights"),
        )
}
