@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.evidently.kotlin.inputs

import com.pulumi.aws.evidently.inputs.ProjectDataDeliveryCloudwatchLogsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property logGroup The name of the log group where the project stores evaluation events.
 */
public data class ProjectDataDeliveryCloudwatchLogsArgs(
    public val logGroup: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.evidently.inputs.ProjectDataDeliveryCloudwatchLogsArgs> {
    override fun toJava(): com.pulumi.aws.evidently.inputs.ProjectDataDeliveryCloudwatchLogsArgs =
        com.pulumi.aws.evidently.inputs.ProjectDataDeliveryCloudwatchLogsArgs.builder()
            .logGroup(logGroup?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ProjectDataDeliveryCloudwatchLogsArgs].
 */
@PulumiTagMarker
public class ProjectDataDeliveryCloudwatchLogsArgsBuilder internal constructor() {
    private var logGroup: Output<String>? = null

    /**
     * @param value The name of the log group where the project stores evaluation events.
     */
    @JvmName("hrdoucqfugwbeqbm")
    public suspend fun logGroup(`value`: Output<String>) {
        this.logGroup = value
    }

    /**
     * @param value The name of the log group where the project stores evaluation events.
     */
    @JvmName("yfrkkgtxsbtjpnnt")
    public suspend fun logGroup(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logGroup = mapped
    }

    internal fun build(): ProjectDataDeliveryCloudwatchLogsArgs =
        ProjectDataDeliveryCloudwatchLogsArgs(
            logGroup = logGroup,
        )
}
