@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.evidently.kotlin.inputs

import com.pulumi.aws.evidently.inputs.ProjectDataDeliveryS3DestinationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property bucket The name of the bucket in which Evidently stores evaluation events.
 * @property prefix The bucket prefix in which Evidently stores evaluation events.
 */
public data class ProjectDataDeliveryS3DestinationArgs(
    public val bucket: Output<String>? = null,
    public val prefix: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.evidently.inputs.ProjectDataDeliveryS3DestinationArgs> {
    override fun toJava(): com.pulumi.aws.evidently.inputs.ProjectDataDeliveryS3DestinationArgs =
        com.pulumi.aws.evidently.inputs.ProjectDataDeliveryS3DestinationArgs.builder()
            .bucket(bucket?.applyValue({ args0 -> args0 }))
            .prefix(prefix?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ProjectDataDeliveryS3DestinationArgs].
 */
@PulumiTagMarker
public class ProjectDataDeliveryS3DestinationArgsBuilder internal constructor() {
    private var bucket: Output<String>? = null

    private var prefix: Output<String>? = null

    /**
     * @param value The name of the bucket in which Evidently stores evaluation events.
     */
    @JvmName("fwbasypshugurdfl")
    public suspend fun bucket(`value`: Output<String>) {
        this.bucket = value
    }

    /**
     * @param value The bucket prefix in which Evidently stores evaluation events.
     */
    @JvmName("wllxxhidyvkcoqff")
    public suspend fun prefix(`value`: Output<String>) {
        this.prefix = value
    }

    /**
     * @param value The name of the bucket in which Evidently stores evaluation events.
     */
    @JvmName("espcxadjkdnrwukf")
    public suspend fun bucket(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bucket = mapped
    }

    /**
     * @param value The bucket prefix in which Evidently stores evaluation events.
     */
    @JvmName("mgpyrvpjvplgegqh")
    public suspend fun prefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.prefix = mapped
    }

    internal fun build(): ProjectDataDeliveryS3DestinationArgs = ProjectDataDeliveryS3DestinationArgs(
        bucket = bucket,
        prefix = prefix,
    )
}
