@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.evidently.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property name The name of the variation. Minimum length of `1`. Maximum length of `127`.
 * @property value A block that specifies the value assigned to this variation. Detailed below
 */
public data class FeatureVariation(
    public val name: String,
    public val `value`: FeatureVariationValue,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.evidently.outputs.FeatureVariation): FeatureVariation = FeatureVariation(
            name = javaType.name(),
            `value` = javaType.`value`().let({ args0 ->
                com.pulumi.aws.evidently.kotlin.outputs.FeatureVariationValue.Companion.toKotlin(args0)
            }),
        )
    }
}
