@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.evidently.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property entityIdKey Specifies the entity, such as a user or session, that does an action that causes a metric value to be recorded. An example is `userDetails.userID`.
 * @property eventPattern Specifies The EventBridge event pattern that defines how the metric is recorded.
 * @property name Specifies the name for the metric.
 * @property unitLabel Specifies a label for the units that the metric is measuring.
 * @property valueKey Specifies the value that is tracked to produce the metric.
 */
public data class LaunchMetricMonitorMetricDefinition(
    public val entityIdKey: String,
    public val eventPattern: String? = null,
    public val name: String,
    public val unitLabel: String? = null,
    public val valueKey: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.evidently.outputs.LaunchMetricMonitorMetricDefinition): LaunchMetricMonitorMetricDefinition = LaunchMetricMonitorMetricDefinition(
            entityIdKey = javaType.entityIdKey(),
            eventPattern = javaType.eventPattern().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            unitLabel = javaType.unitLabel().map({ args0 -> args0 }).orElse(null),
            valueKey = javaType.valueKey(),
        )
    }
}
