@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.evidently.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 *
 * @property evaluationOrder Specifies a number indicating the order to use to evaluate segment overrides, if there are more than one. Segment overrides with lower numbers are evaluated first.
 * @property segment The name or ARN of the segment to use.
 * @property weights The traffic allocation percentages among the feature variations to assign to this segment. This is a set of key-value pairs. The keys are variation names. The values represent the amount of traffic to allocate to that variation for this segment. This is expressed in thousandths of a percent, so a weight of 50000 represents 50% of traffic.
 */
public data class LaunchScheduledSplitsConfigStepSegmentOverride(
    public val evaluationOrder: Int,
    public val segment: String,
    public val weights: Map<String, Int>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.evidently.outputs.LaunchScheduledSplitsConfigStepSegmentOverride): LaunchScheduledSplitsConfigStepSegmentOverride =
            LaunchScheduledSplitsConfigStepSegmentOverride(
                evaluationOrder = javaType.evaluationOrder(),
                segment = javaType.segment(),
                weights = javaType.weights().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            )
    }
}
