@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.evidently.kotlin.outputs

import kotlin.Suppress

/**
 *
 * @property cloudwatchLogs A block that defines the CloudWatch Log Group that stores the evaluation events. See below.
 * @property s3Destination A block that defines the S3 bucket and prefix that stores the evaluation events. See below.
 */
public data class ProjectDataDelivery(
    public val cloudwatchLogs: ProjectDataDeliveryCloudwatchLogs? = null,
    public val s3Destination: ProjectDataDeliveryS3Destination? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.evidently.outputs.ProjectDataDelivery): ProjectDataDelivery = ProjectDataDelivery(
            cloudwatchLogs = javaType.cloudwatchLogs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.evidently.kotlin.outputs.ProjectDataDeliveryCloudwatchLogs.Companion.toKotlin(args0)
                })
            }).orElse(null),
            s3Destination = javaType.s3Destination().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.evidently.kotlin.outputs.ProjectDataDeliveryS3Destination.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
