@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.finspace.kotlin

import com.pulumi.aws.finspace.kotlin.outputs.KxClusterAutoScalingConfiguration
import com.pulumi.aws.finspace.kotlin.outputs.KxClusterCacheStorageConfiguration
import com.pulumi.aws.finspace.kotlin.outputs.KxClusterCapacityConfiguration
import com.pulumi.aws.finspace.kotlin.outputs.KxClusterCode
import com.pulumi.aws.finspace.kotlin.outputs.KxClusterDatabase
import com.pulumi.aws.finspace.kotlin.outputs.KxClusterSavedownStorageConfiguration
import com.pulumi.aws.finspace.kotlin.outputs.KxClusterScalingGroupConfiguration
import com.pulumi.aws.finspace.kotlin.outputs.KxClusterTickerplantLogConfiguration
import com.pulumi.aws.finspace.kotlin.outputs.KxClusterVpcConfiguration
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.finspace.kotlin.outputs.KxClusterAutoScalingConfiguration.Companion.toKotlin as kxClusterAutoScalingConfigurationToKotlin
import com.pulumi.aws.finspace.kotlin.outputs.KxClusterCacheStorageConfiguration.Companion.toKotlin as kxClusterCacheStorageConfigurationToKotlin
import com.pulumi.aws.finspace.kotlin.outputs.KxClusterCapacityConfiguration.Companion.toKotlin as kxClusterCapacityConfigurationToKotlin
import com.pulumi.aws.finspace.kotlin.outputs.KxClusterCode.Companion.toKotlin as kxClusterCodeToKotlin
import com.pulumi.aws.finspace.kotlin.outputs.KxClusterDatabase.Companion.toKotlin as kxClusterDatabaseToKotlin
import com.pulumi.aws.finspace.kotlin.outputs.KxClusterSavedownStorageConfiguration.Companion.toKotlin as kxClusterSavedownStorageConfigurationToKotlin
import com.pulumi.aws.finspace.kotlin.outputs.KxClusterScalingGroupConfiguration.Companion.toKotlin as kxClusterScalingGroupConfigurationToKotlin
import com.pulumi.aws.finspace.kotlin.outputs.KxClusterTickerplantLogConfiguration.Companion.toKotlin as kxClusterTickerplantLogConfigurationToKotlin
import com.pulumi.aws.finspace.kotlin.outputs.KxClusterVpcConfiguration.Companion.toKotlin as kxClusterVpcConfigurationToKotlin

/**
 * Builder for [KxCluster].
 */
@PulumiTagMarker
public class KxClusterResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: KxClusterArgs = KxClusterArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend KxClusterArgsBuilder.() -> Unit) {
        val builder = KxClusterArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): KxCluster {
        val builtJavaResource = com.pulumi.aws.finspace.KxCluster(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return KxCluster(builtJavaResource)
    }
}

/**
 * Resource for managing an AWS FinSpace Kx Cluster.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.finspace.KxCluster;
 * import com.pulumi.aws.finspace.KxClusterArgs;
 * import com.pulumi.aws.finspace.inputs.KxClusterCapacityConfigurationArgs;
 * import com.pulumi.aws.finspace.inputs.KxClusterVpcConfigurationArgs;
 * import com.pulumi.aws.finspace.inputs.KxClusterCacheStorageConfigurationArgs;
 * import com.pulumi.aws.finspace.inputs.KxClusterDatabaseArgs;
 * import com.pulumi.aws.finspace.inputs.KxClusterCodeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new KxCluster("example", KxClusterArgs.builder()
 *             .name("my-tf-kx-cluster")
 *             .environmentId(exampleAwsFinspaceKxEnvironment.id())
 *             .type("HDB")
 *             .releaseLabel("1.0")
 *             .azMode("SINGLE")
 *             .availabilityZoneId("use1-az2")
 *             .capacityConfiguration(KxClusterCapacityConfigurationArgs.builder()
 *                 .nodeType("kx.s.2xlarge")
 *                 .nodeCount(2)
 *                 .build())
 *             .vpcConfiguration(KxClusterVpcConfigurationArgs.builder()
 *                 .vpcId(test.id())
 *                 .securityGroupIds(exampleAwsSecurityGroup.id())
 *                 .subnetIds(exampleAwsSubnet.id())
 *                 .ipAddressType("IP_V4")
 *                 .build())
 *             .cacheStorageConfigurations(KxClusterCacheStorageConfigurationArgs.builder()
 *                 .type("CACHE_1000")
 *                 .size(1200)
 *                 .build())
 *             .databases(KxClusterDatabaseArgs.builder()
 *                 .databaseName(exampleAwsFinspaceKxDatabase.name())
 *                 .cacheConfiguration(%!v(PANIC=Format method: runtime error: invalid memory address or nil pointer dereference))
 *                 .build())
 *             .code(KxClusterCodeArgs.builder()
 *                 .s3Bucket(testAwsS3Bucket.id())
 *                 .s3Key(object.key())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:finspace:KxCluster
 *     properties:
 *       name: my-tf-kx-cluster
 *       environmentId: ${exampleAwsFinspaceKxEnvironment.id}
 *       type: HDB
 *       releaseLabel: '1.0'
 *       azMode: SINGLE
 *       availabilityZoneId: use1-az2
 *       capacityConfiguration:
 *         nodeType: kx.s.2xlarge
 *         nodeCount: 2
 *       vpcConfiguration:
 *         vpcId: ${test.id}
 *         securityGroupIds:
 *           - ${exampleAwsSecurityGroup.id}
 *         subnetIds:
 *           - ${exampleAwsSubnet.id}
 *         ipAddressType: IP_V4
 *       cacheStorageConfigurations:
 *         - type: CACHE_1000
 *           size: 1200
 *       databases:
 *         - databaseName: ${exampleAwsFinspaceKxDatabase.name}
 *           cacheConfiguration:
 *             - cacheType: CACHE_1000
 *               dbPaths: /
 *       code:
 *         s3Bucket: ${testAwsS3Bucket.id}
 *         s3Key: ${object.key}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import an AWS FinSpace Kx Cluster using the `id` (environment ID and cluster name, comma-delimited). For example:
 * ```sh
 * $ pulumi import aws:finspace/kxCluster:KxCluster example n3ceo7wqxoxcti5tujqwzs,my-tf-kx-cluster
 * ```
 */
public class KxCluster internal constructor(
    override val javaResource: com.pulumi.aws.finspace.KxCluster,
) : KotlinCustomResource(javaResource, KxClusterMapper) {
    /**
     * Amazon Resource Name (ARN) identifier of the KX cluster.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Configuration based on which FinSpace will scale in or scale out nodes in your cluster. See auto_scaling_configuration.
     */
    public val autoScalingConfiguration: Output<KxClusterAutoScalingConfiguration>?
        get() = javaResource.autoScalingConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> kxClusterAutoScalingConfigurationToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The availability zone identifiers for the requested regions. Required when `az_mode` is set to SINGLE.
     */
    public val availabilityZoneId: Output<String>?
        get() = javaResource.availabilityZoneId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The number of availability zones you want to assign per cluster. This can be one of the following:
     * * SINGLE - Assigns one availability zone per cluster.
     * * MULTI - Assigns all the availability zones per cluster.
     */
    public val azMode: Output<String>
        get() = javaResource.azMode().applyValue({ args0 -> args0 })

    /**
     * Configurations for a read only cache storage associated with a cluster. This cache will be stored as an FSx Lustre that reads from the S3 store. See cache_storage_configuration.
     */
    public val cacheStorageConfigurations: Output<List<KxClusterCacheStorageConfiguration>>?
        get() = javaResource.cacheStorageConfigurations().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        kxClusterCacheStorageConfigurationToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * Structure for the metadata of a cluster. Includes information like the CPUs needed, memory of instances, and number of instances. See capacity_configuration.
     */
    public val capacityConfiguration: Output<KxClusterCapacityConfiguration>?
        get() = javaResource.capacityConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> kxClusterCapacityConfigurationToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Details of the custom code that you want to use inside a cluster when analyzing data. Consists of the S3 source bucket, location, object version, and the relative path from where the custom code is loaded into the cluster. See code.
     */
    public val code: Output<KxClusterCode>?
        get() = javaResource.code().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    kxClusterCodeToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * List of key-value pairs to make available inside the cluster.
     */
    public val commandLineArguments: Output<Map<String, String>>?
        get() = javaResource.commandLineArguments().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0.key.to(args0.value) }).toMap()
            }).orElse(null)
        })

    /**
     * Timestamp at which the cluster is created in FinSpace. Value determined as epoch time in seconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000.
     */
    public val createdTimestamp: Output<String>
        get() = javaResource.createdTimestamp().applyValue({ args0 -> args0 })

    /**
     * KX database that will be available for querying. Defined below.
     */
    public val databases: Output<List<KxClusterDatabase>>?
        get() = javaResource.databases().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> kxClusterDatabaseToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * Description of the cluster.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Unique identifier for the KX environment.
     */
    public val environmentId: Output<String>
        get() = javaResource.environmentId().applyValue({ args0 -> args0 })

    /**
     * An IAM role that defines a set of permissions associated with a cluster. These permissions are assumed when a cluster attempts to access another cluster.
     */
    public val executionRole: Output<String>?
        get() = javaResource.executionRole().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Path to Q program that will be run at launch of a cluster. This is a relative path within .zip file that contains the custom code, which will be loaded on the cluster. It must include the file name itself. For example, somedir/init.q.
     */
    public val initializationScript: Output<String>?
        get() = javaResource.initializationScript().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Last timestamp at which the cluster was updated in FinSpace. Value determined as epoch time in seconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000.
     */
    public val lastModifiedTimestamp: Output<String>
        get() = javaResource.lastModifiedTimestamp().applyValue({ args0 -> args0 })

    /**
     * Unique name for the cluster that you want to create.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Version of FinSpace Managed kdb to run.
     */
    public val releaseLabel: Output<String>
        get() = javaResource.releaseLabel().applyValue({ args0 -> args0 })

    /**
     * Size and type of the temporary storage that is used to hold data during the savedown process. This parameter is required when you choose `type` as RDB. All the data written to this storage space is lost when the cluster node is restarted. See savedown_storage_configuration.
     */
    public val savedownStorageConfiguration: Output<KxClusterSavedownStorageConfiguration>?
        get() = javaResource.savedownStorageConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> kxClusterSavedownStorageConfigurationToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The structure that stores the configuration details of a scaling group.
     */
    public val scalingGroupConfiguration: Output<KxClusterScalingGroupConfiguration>?
        get() = javaResource.scalingGroupConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> kxClusterScalingGroupConfigurationToKotlin(args0) })
            }).orElse(null)
        })

    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    public val statusReason: Output<String>
        get() = javaResource.statusReason().applyValue({ args0 -> args0 })

    /**
     * Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * A configuration to store Tickerplant logs. It consists of a list of volumes that will be mounted to your cluster. For the cluster type Tickerplant , the location of the TP volume on the cluster will be available by using the global variable .aws.tp_log_path.
     */
    public val tickerplantLogConfigurations: Output<List<KxClusterTickerplantLogConfiguration>>?
        get() = javaResource.tickerplantLogConfigurations().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        kxClusterTickerplantLogConfigurationToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * Type of KDB database. The following types are available:
     * * HDB - Historical Database. The data is only accessible with read-only permissions from one of the FinSpace managed KX databases mounted to the cluster.
     * * RDB - Realtime Database. This type of database captures all the data from a ticker plant and stores it in memory until the end of day, after which it writes all of its data to a disk and reloads the HDB. This cluster type requires local storage for temporary storage of data during the savedown process. If you specify this field in your request, you must provide the `savedownStorageConfiguration` parameter.
     * * GATEWAY - A gateway cluster allows you to access data across processes in kdb systems. It allows you to create your own routing logic using the initialization scripts and custom code. This type of cluster does not require a  writable local storage.
     * * GP - A general purpose cluster allows you to quickly iterate on code during development by granting greater access to system commands and enabling a fast reload of custom code. This cluster type can optionally mount databases including cache and savedown storage. For this cluster type, the node count is fixed at 1. It does not support autoscaling and supports only `SINGLE` AZ mode.
     * * Tickerplant – A tickerplant cluster allows you to subscribe to feed handlers based on IAM permissions. It can publish to RDBs, other Tickerplants, and real-time subscribers (RTS). Tickerplants can persist messages to log, which is readable by any RDB environment. It supports only single-node that is only one kdb process.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Configuration details about the network where the Privatelink endpoint of the cluster resides. See vpc_configuration.
     * The following arguments are optional:
     */
    public val vpcConfiguration: Output<KxClusterVpcConfiguration>
        get() = javaResource.vpcConfiguration().applyValue({ args0 ->
            args0.let({ args0 ->
                kxClusterVpcConfigurationToKotlin(args0)
            })
        })
}

public object KxClusterMapper : ResourceMapper<KxCluster> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.finspace.KxCluster::class == javaResource::class

    override fun map(javaResource: Resource): KxCluster = KxCluster(
        javaResource as
            com.pulumi.aws.finspace.KxCluster,
    )
}

/**
 * @see [KxCluster].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [KxCluster].
 */
public suspend fun kxCluster(name: String, block: suspend KxClusterResourceBuilder.() -> Unit): KxCluster {
    val builder = KxClusterResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [KxCluster].
 * @param name The _unique_ name of the resulting resource.
 */
public fun kxCluster(name: String): KxCluster {
    val builder = KxClusterResourceBuilder()
    builder.name(name)
    return builder.build()
}
