@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.finspace.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [KxDatabase].
 */
@PulumiTagMarker
public class KxDatabaseResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: KxDatabaseArgs = KxDatabaseArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend KxDatabaseArgsBuilder.() -> Unit) {
        val builder = KxDatabaseArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): KxDatabase {
        val builtJavaResource = com.pulumi.aws.finspace.KxDatabase(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return KxDatabase(builtJavaResource)
    }
}

/**
 * Resource for managing an AWS FinSpace Kx Database.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.kms.Key("example", {
 *     description: "Example KMS Key",
 *     deletionWindowInDays: 7,
 * });
 * const exampleKxEnvironment = new aws.finspace.KxEnvironment("example", {
 *     name: "my-tf-kx-environment",
 *     kmsKeyId: example.arn,
 * });
 * const exampleKxDatabase = new aws.finspace.KxDatabase("example", {
 *     environmentId: exampleKxEnvironment.id,
 *     name: "my-tf-kx-database",
 *     description: "Example database description",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.kms.Key("example",
 *     description="Example KMS Key",
 *     deletion_window_in_days=7)
 * example_kx_environment = aws.finspace.KxEnvironment("example",
 *     name="my-tf-kx-environment",
 *     kms_key_id=example.arn)
 * example_kx_database = aws.finspace.KxDatabase("example",
 *     environment_id=example_kx_environment.id,
 *     name="my-tf-kx-database",
 *     description="Example database description")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Kms.Key("example", new()
 *     {
 *         Description = "Example KMS Key",
 *         DeletionWindowInDays = 7,
 *     });
 *     var exampleKxEnvironment = new Aws.FinSpace.KxEnvironment("example", new()
 *     {
 *         Name = "my-tf-kx-environment",
 *         KmsKeyId = example.Arn,
 *     });
 *     var exampleKxDatabase = new Aws.FinSpace.KxDatabase("example", new()
 *     {
 *         EnvironmentId = exampleKxEnvironment.Id,
 *         Name = "my-tf-kx-database",
 *         Description = "Example database description",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/finspace"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/kms"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := kms.NewKey(ctx, "example", &kms.KeyArgs{
 * 			Description:          pulumi.String("Example KMS Key"),
 * 			DeletionWindowInDays: pulumi.Int(7),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleKxEnvironment, err := finspace.NewKxEnvironment(ctx, "example", &finspace.KxEnvironmentArgs{
 * 			Name:     pulumi.String("my-tf-kx-environment"),
 * 			KmsKeyId: example.Arn,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = finspace.NewKxDatabase(ctx, "example", &finspace.KxDatabaseArgs{
 * 			EnvironmentId: exampleKxEnvironment.ID(),
 * 			Name:          pulumi.String("my-tf-kx-database"),
 * 			Description:   pulumi.String("Example database description"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.kms.Key;
 * import com.pulumi.aws.kms.KeyArgs;
 * import com.pulumi.aws.finspace.KxEnvironment;
 * import com.pulumi.aws.finspace.KxEnvironmentArgs;
 * import com.pulumi.aws.finspace.KxDatabase;
 * import com.pulumi.aws.finspace.KxDatabaseArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Key("example", KeyArgs.builder()
 *             .description("Example KMS Key")
 *             .deletionWindowInDays(7)
 *             .build());
 *         var exampleKxEnvironment = new KxEnvironment("exampleKxEnvironment", KxEnvironmentArgs.builder()
 *             .name("my-tf-kx-environment")
 *             .kmsKeyId(example.arn())
 *             .build());
 *         var exampleKxDatabase = new KxDatabase("exampleKxDatabase", KxDatabaseArgs.builder()
 *             .environmentId(exampleKxEnvironment.id())
 *             .name("my-tf-kx-database")
 *             .description("Example database description")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:kms:Key
 *     properties:
 *       description: Example KMS Key
 *       deletionWindowInDays: 7
 *   exampleKxEnvironment:
 *     type: aws:finspace:KxEnvironment
 *     name: example
 *     properties:
 *       name: my-tf-kx-environment
 *       kmsKeyId: ${example.arn}
 *   exampleKxDatabase:
 *     type: aws:finspace:KxDatabase
 *     name: example
 *     properties:
 *       environmentId: ${exampleKxEnvironment.id}
 *       name: my-tf-kx-database
 *       description: Example database description
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import an AWS FinSpace Kx Database using the `id` (environment ID and database name, comma-delimited). For example:
 * ```sh
 * $ pulumi import aws:finspace/kxDatabase:KxDatabase example n3ceo7wqxoxcti5tujqwzs,my-tf-kx-database
 * ```
 */
public class KxDatabase internal constructor(
    override val javaResource: com.pulumi.aws.finspace.KxDatabase,
) : KotlinCustomResource(javaResource, KxDatabaseMapper) {
    /**
     * Amazon Resource Name (ARN) identifier of the KX database.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Timestamp at which the databse is created in FinSpace. Value determined as epoch time in seconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000.
     */
    public val createdTimestamp: Output<String>
        get() = javaResource.createdTimestamp().applyValue({ args0 -> args0 })

    /**
     * Description of the KX database.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Unique identifier for the KX environment.
     */
    public val environmentId: Output<String>
        get() = javaResource.environmentId().applyValue({ args0 -> args0 })

    /**
     * Last timestamp at which the database was updated in FinSpace. Value determined as epoch time in seconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000.
     */
    public val lastModifiedTimestamp: Output<String>
        get() = javaResource.lastModifiedTimestamp().applyValue({ args0 -> args0 })

    /**
     * Name of the KX database.
     * The following arguments are optional:
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object KxDatabaseMapper : ResourceMapper<KxDatabase> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.finspace.KxDatabase::class == javaResource::class

    override fun map(javaResource: Resource): KxDatabase = KxDatabase(
        javaResource as
            com.pulumi.aws.finspace.KxDatabase,
    )
}

/**
 * @see [KxDatabase].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [KxDatabase].
 */
public suspend fun kxDatabase(name: String, block: suspend KxDatabaseResourceBuilder.() -> Unit): KxDatabase {
    val builder = KxDatabaseResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [KxDatabase].
 * @param name The _unique_ name of the resulting resource.
 */
public fun kxDatabase(name: String): KxDatabase {
    val builder = KxDatabaseResourceBuilder()
    builder.name(name)
    return builder.build()
}
