@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.finspace.kotlin

import com.pulumi.aws.finspace.KxDatabaseArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS FinSpace Kx Database.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.kms.Key("example", {
 *     description: "Example KMS Key",
 *     deletionWindowInDays: 7,
 * });
 * const exampleKxEnvironment = new aws.finspace.KxEnvironment("example", {
 *     name: "my-tf-kx-environment",
 *     kmsKeyId: example.arn,
 * });
 * const exampleKxDatabase = new aws.finspace.KxDatabase("example", {
 *     environmentId: exampleKxEnvironment.id,
 *     name: "my-tf-kx-database",
 *     description: "Example database description",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.kms.Key("example",
 *     description="Example KMS Key",
 *     deletion_window_in_days=7)
 * example_kx_environment = aws.finspace.KxEnvironment("example",
 *     name="my-tf-kx-environment",
 *     kms_key_id=example.arn)
 * example_kx_database = aws.finspace.KxDatabase("example",
 *     environment_id=example_kx_environment.id,
 *     name="my-tf-kx-database",
 *     description="Example database description")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Kms.Key("example", new()
 *     {
 *         Description = "Example KMS Key",
 *         DeletionWindowInDays = 7,
 *     });
 *     var exampleKxEnvironment = new Aws.FinSpace.KxEnvironment("example", new()
 *     {
 *         Name = "my-tf-kx-environment",
 *         KmsKeyId = example.Arn,
 *     });
 *     var exampleKxDatabase = new Aws.FinSpace.KxDatabase("example", new()
 *     {
 *         EnvironmentId = exampleKxEnvironment.Id,
 *         Name = "my-tf-kx-database",
 *         Description = "Example database description",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/finspace"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/kms"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := kms.NewKey(ctx, "example", &kms.KeyArgs{
 * 			Description:          pulumi.String("Example KMS Key"),
 * 			DeletionWindowInDays: pulumi.Int(7),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleKxEnvironment, err := finspace.NewKxEnvironment(ctx, "example", &finspace.KxEnvironmentArgs{
 * 			Name:     pulumi.String("my-tf-kx-environment"),
 * 			KmsKeyId: example.Arn,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = finspace.NewKxDatabase(ctx, "example", &finspace.KxDatabaseArgs{
 * 			EnvironmentId: exampleKxEnvironment.ID(),
 * 			Name:          pulumi.String("my-tf-kx-database"),
 * 			Description:   pulumi.String("Example database description"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.kms.Key;
 * import com.pulumi.aws.kms.KeyArgs;
 * import com.pulumi.aws.finspace.KxEnvironment;
 * import com.pulumi.aws.finspace.KxEnvironmentArgs;
 * import com.pulumi.aws.finspace.KxDatabase;
 * import com.pulumi.aws.finspace.KxDatabaseArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Key("example", KeyArgs.builder()
 *             .description("Example KMS Key")
 *             .deletionWindowInDays(7)
 *             .build());
 *         var exampleKxEnvironment = new KxEnvironment("exampleKxEnvironment", KxEnvironmentArgs.builder()
 *             .name("my-tf-kx-environment")
 *             .kmsKeyId(example.arn())
 *             .build());
 *         var exampleKxDatabase = new KxDatabase("exampleKxDatabase", KxDatabaseArgs.builder()
 *             .environmentId(exampleKxEnvironment.id())
 *             .name("my-tf-kx-database")
 *             .description("Example database description")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:kms:Key
 *     properties:
 *       description: Example KMS Key
 *       deletionWindowInDays: 7
 *   exampleKxEnvironment:
 *     type: aws:finspace:KxEnvironment
 *     name: example
 *     properties:
 *       name: my-tf-kx-environment
 *       kmsKeyId: ${example.arn}
 *   exampleKxDatabase:
 *     type: aws:finspace:KxDatabase
 *     name: example
 *     properties:
 *       environmentId: ${exampleKxEnvironment.id}
 *       name: my-tf-kx-database
 *       description: Example database description
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import an AWS FinSpace Kx Database using the `id` (environment ID and database name, comma-delimited). For example:
 * ```sh
 * $ pulumi import aws:finspace/kxDatabase:KxDatabase example n3ceo7wqxoxcti5tujqwzs,my-tf-kx-database
 * ```
 * @property description Description of the KX database.
 * @property environmentId Unique identifier for the KX environment.
 * @property name Name of the KX database.
 * The following arguments are optional:
 * @property tags Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class KxDatabaseArgs(
    public val description: Output<String>? = null,
    public val environmentId: Output<String>? = null,
    public val name: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.finspace.KxDatabaseArgs> {
    override fun toJava(): com.pulumi.aws.finspace.KxDatabaseArgs =
        com.pulumi.aws.finspace.KxDatabaseArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .environmentId(environmentId?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [KxDatabaseArgs].
 */
@PulumiTagMarker
public class KxDatabaseArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var environmentId: Output<String>? = null

    private var name: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Description of the KX database.
     */
    @JvmName("fohnapboyypxlyig")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Unique identifier for the KX environment.
     */
    @JvmName("lojhnepboyojrija")
    public suspend fun environmentId(`value`: Output<String>) {
        this.environmentId = value
    }

    /**
     * @param value Name of the KX database.
     * The following arguments are optional:
     */
    @JvmName("ubcpdxwalgsbcyit")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("wtcegpmijmubhfye")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Description of the KX database.
     */
    @JvmName("jgvaqwvnkffthfss")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Unique identifier for the KX environment.
     */
    @JvmName("tpqdlinwxgehbtof")
    public suspend fun environmentId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.environmentId = mapped
    }

    /**
     * @param value Name of the KX database.
     * The following arguments are optional:
     */
    @JvmName("yyymrpljkuelhdnp")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("lielrfeqhdpuynma")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("kynwpedguhdfldxb")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): KxDatabaseArgs = KxDatabaseArgs(
        description = description,
        environmentId = environmentId,
        name = name,
        tags = tags,
    )
}
