@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.finspace.kotlin

import com.pulumi.aws.finspace.KxDataviewArgs.builder
import com.pulumi.aws.finspace.kotlin.inputs.KxDataviewSegmentConfigurationArgs
import com.pulumi.aws.finspace.kotlin.inputs.KxDataviewSegmentConfigurationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS FinSpace Kx Dataview.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.finspace.KxDataview("example", {
 *     name: "my-tf-kx-dataview",
 *     environmentId: exampleAwsFinspaceKxEnvironment.id,
 *     databaseName: exampleAwsFinspaceKxDatabase.name,
 *     availabilityZoneId: "use1-az2",
 *     description: "Terraform managed Kx Dataview",
 *     azMode: "SINGLE",
 *     autoUpdate: true,
 *     segmentConfigurations: [{
 *         volumeName: exampleAwsFinspaceKxVolume.name,
 *         dbPaths: ["/*"],
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.finspace.KxDataview("example",
 *     name="my-tf-kx-dataview",
 *     environment_id=example_aws_finspace_kx_environment["id"],
 *     database_name=example_aws_finspace_kx_database["name"],
 *     availability_zone_id="use1-az2",
 *     description="Terraform managed Kx Dataview",
 *     az_mode="SINGLE",
 *     auto_update=True,
 *     segment_configurations=[{
 *         "volume_name": example_aws_finspace_kx_volume["name"],
 *         "db_paths": ["/*"],
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.FinSpace.KxDataview("example", new()
 *     {
 *         Name = "my-tf-kx-dataview",
 *         EnvironmentId = exampleAwsFinspaceKxEnvironment.Id,
 *         DatabaseName = exampleAwsFinspaceKxDatabase.Name,
 *         AvailabilityZoneId = "use1-az2",
 *         Description = "Terraform managed Kx Dataview",
 *         AzMode = "SINGLE",
 *         AutoUpdate = true,
 *         SegmentConfigurations = new[]
 *         {
 *             new Aws.FinSpace.Inputs.KxDataviewSegmentConfigurationArgs
 *             {
 *                 VolumeName = exampleAwsFinspaceKxVolume.Name,
 *                 DbPaths = new[]
 *                 {
 *                     "/*",
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/finspace"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := finspace.NewKxDataview(ctx, "example", &finspace.KxDataviewArgs{
 * 			Name:               pulumi.String("my-tf-kx-dataview"),
 * 			EnvironmentId:      pulumi.Any(exampleAwsFinspaceKxEnvironment.Id),
 * 			DatabaseName:       pulumi.Any(exampleAwsFinspaceKxDatabase.Name),
 * 			AvailabilityZoneId: pulumi.String("use1-az2"),
 * 			Description:        pulumi.String("Terraform managed Kx Dataview"),
 * 			AzMode:             pulumi.String("SINGLE"),
 * 			AutoUpdate:         pulumi.Bool(true),
 * 			SegmentConfigurations: finspace.KxDataviewSegmentConfigurationArray{
 * 				&finspace.KxDataviewSegmentConfigurationArgs{
 * 					VolumeName: pulumi.Any(exampleAwsFinspaceKxVolume.Name),
 * 					DbPaths: pulumi.StringArray{
 * 						pulumi.String("/*"),
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.finspace.KxDataview;
 * import com.pulumi.aws.finspace.KxDataviewArgs;
 * import com.pulumi.aws.finspace.inputs.KxDataviewSegmentConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new KxDataview("example", KxDataviewArgs.builder()
 *             .name("my-tf-kx-dataview")
 *             .environmentId(exampleAwsFinspaceKxEnvironment.id())
 *             .databaseName(exampleAwsFinspaceKxDatabase.name())
 *             .availabilityZoneId("use1-az2")
 *             .description("Terraform managed Kx Dataview")
 *             .azMode("SINGLE")
 *             .autoUpdate(true)
 *             .segmentConfigurations(KxDataviewSegmentConfigurationArgs.builder()
 *                 .volumeName(exampleAwsFinspaceKxVolume.name())
 *                 .dbPaths("/*")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:finspace:KxDataview
 *     properties:
 *       name: my-tf-kx-dataview
 *       environmentId: ${exampleAwsFinspaceKxEnvironment.id}
 *       databaseName: ${exampleAwsFinspaceKxDatabase.name}
 *       availabilityZoneId: use1-az2
 *       description: Terraform managed Kx Dataview
 *       azMode: SINGLE
 *       autoUpdate: true
 *       segmentConfigurations:
 *         - volumeName: ${exampleAwsFinspaceKxVolume.name}
 *           dbPaths:
 *             - /*
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import an AWS FinSpace Kx Cluster using the `id` (environment ID and cluster name, comma-delimited). For example:
 * ```sh
 * $ pulumi import aws:finspace/kxDataview:KxDataview example n3ceo7wqxoxcti5tujqwzs,my-tf-kx-database,my-tf-kx-dataview
 * ```
 * @property autoUpdate The option to specify whether you want to apply all the future additions and corrections automatically to the dataview, when you ingest new changesets. The default value is false.
 * @property availabilityZoneId The identifier of the availability zones. If attaching a volume, the volume must be in the same availability zone as the dataview that you are attaching to.
 * @property azMode The number of availability zones you want to assign per cluster. This can be one of the following:
 * * `SINGLE` - Assigns one availability zone per cluster.
 * * `MULTI` - Assigns all the availability zones per cluster.
 * @property changesetId A unique identifier of the changeset of the database that you want to use to ingest data.
 * @property databaseName The name of the database where you want to create a dataview.
 * @property description A description for the dataview.
 * @property environmentId Unique identifier for the KX environment.
 * @property name A unique identifier for the dataview.
 * The following arguments are optional:
 * @property readWrite The option to specify whether you want to make the dataview writable to perform database maintenance. The following are some considerations related to writable dataviews.
 * * You cannot create partial writable dataviews. When you create writeable dataviews you must provide the entire database path. You cannot perform updates on a writeable dataview. Hence, `auto_update` must be set as `false` if `read_write` is `true` for a dataview.
 * * You must also use a unique volume for creating a writeable dataview. So, if you choose a volume that is already in use by another dataview, the dataview creation fails.
 * * Once you create a dataview as writeable, you cannot change it to read-only. So, you cannot update the `read_write` parameter later.
 * @property segmentConfigurations The configuration that contains the database path of the data that you want to place on each selected volume. Each segment must have a unique database path for each volume. If you do not explicitly specify any database path for a volume, they are accessible from the cluster through the default S3/object store segment. See segment_configurations below.
 * @property tags Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * */*/*/*/*/*/
 */
public data class KxDataviewArgs(
    public val autoUpdate: Output<Boolean>? = null,
    public val availabilityZoneId: Output<String>? = null,
    public val azMode: Output<String>? = null,
    public val changesetId: Output<String>? = null,
    public val databaseName: Output<String>? = null,
    public val description: Output<String>? = null,
    public val environmentId: Output<String>? = null,
    public val name: Output<String>? = null,
    public val readWrite: Output<Boolean>? = null,
    public val segmentConfigurations: Output<List<KxDataviewSegmentConfigurationArgs>>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.finspace.KxDataviewArgs> {
    override fun toJava(): com.pulumi.aws.finspace.KxDataviewArgs =
        com.pulumi.aws.finspace.KxDataviewArgs.builder()
            .autoUpdate(autoUpdate?.applyValue({ args0 -> args0 }))
            .availabilityZoneId(availabilityZoneId?.applyValue({ args0 -> args0 }))
            .azMode(azMode?.applyValue({ args0 -> args0 }))
            .changesetId(changesetId?.applyValue({ args0 -> args0 }))
            .databaseName(databaseName?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .environmentId(environmentId?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .readWrite(readWrite?.applyValue({ args0 -> args0 }))
            .segmentConfigurations(
                segmentConfigurations?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [KxDataviewArgs].
 */
@PulumiTagMarker
public class KxDataviewArgsBuilder internal constructor() {
    private var autoUpdate: Output<Boolean>? = null

    private var availabilityZoneId: Output<String>? = null

    private var azMode: Output<String>? = null

    private var changesetId: Output<String>? = null

    private var databaseName: Output<String>? = null

    private var description: Output<String>? = null

    private var environmentId: Output<String>? = null

    private var name: Output<String>? = null

    private var readWrite: Output<Boolean>? = null

    private var segmentConfigurations: Output<List<KxDataviewSegmentConfigurationArgs>>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The option to specify whether you want to apply all the future additions and corrections automatically to the dataview, when you ingest new changesets. The default value is false.
     */
    @JvmName("ujpxgwaixjgrakyf")
    public suspend fun autoUpdate(`value`: Output<Boolean>) {
        this.autoUpdate = value
    }

    /**
     * @param value The identifier of the availability zones. If attaching a volume, the volume must be in the same availability zone as the dataview that you are attaching to.
     */
    @JvmName("medqfdmlyadxhvwl")
    public suspend fun availabilityZoneId(`value`: Output<String>) {
        this.availabilityZoneId = value
    }

    /**
     * @param value The number of availability zones you want to assign per cluster. This can be one of the following:
     * * `SINGLE` - Assigns one availability zone per cluster.
     * * `MULTI` - Assigns all the availability zones per cluster.
     */
    @JvmName("spruihkfljqjvwmk")
    public suspend fun azMode(`value`: Output<String>) {
        this.azMode = value
    }

    /**
     * @param value A unique identifier of the changeset of the database that you want to use to ingest data.
     */
    @JvmName("gylclhmbeiwcjhvq")
    public suspend fun changesetId(`value`: Output<String>) {
        this.changesetId = value
    }

    /**
     * @param value The name of the database where you want to create a dataview.
     */
    @JvmName("fciutoerhsdjndcd")
    public suspend fun databaseName(`value`: Output<String>) {
        this.databaseName = value
    }

    /**
     * @param value A description for the dataview.
     */
    @JvmName("ctilnpxgkkpvkiyo")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Unique identifier for the KX environment.
     */
    @JvmName("mnlcxmjshwsdqdfk")
    public suspend fun environmentId(`value`: Output<String>) {
        this.environmentId = value
    }

    /**
     * @param value A unique identifier for the dataview.
     * The following arguments are optional:
     */
    @JvmName("fvspccpawpcobhjs")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The option to specify whether you want to make the dataview writable to perform database maintenance. The following are some considerations related to writable dataviews.
     * * You cannot create partial writable dataviews. When you create writeable dataviews you must provide the entire database path. You cannot perform updates on a writeable dataview. Hence, `auto_update` must be set as `false` if `read_write` is `true` for a dataview.
     * * You must also use a unique volume for creating a writeable dataview. So, if you choose a volume that is already in use by another dataview, the dataview creation fails.
     * * Once you create a dataview as writeable, you cannot change it to read-only. So, you cannot update the `read_write` parameter later.
     */
    @JvmName("nsmgpbjysimsflia")
    public suspend fun readWrite(`value`: Output<Boolean>) {
        this.readWrite = value
    }

    /**
     * @param value The configuration that contains the database path of the data that you want to place on each selected volume. Each segment must have a unique database path for each volume. If you do not explicitly specify any database path for a volume, they are accessible from the cluster through the default S3/object store segment. See segment_configurations below.
     */
    @JvmName("pbssutmrvoypvbob")
    public suspend fun segmentConfigurations(`value`: Output<List<KxDataviewSegmentConfigurationArgs>>) {
        this.segmentConfigurations = value
    }

    @JvmName("daqrcmnailrrvjis")
    public suspend fun segmentConfigurations(vararg values: Output<KxDataviewSegmentConfigurationArgs>) {
        this.segmentConfigurations = Output.all(values.asList())
    }

    /**
     * @param values The configuration that contains the database path of the data that you want to place on each selected volume. Each segment must have a unique database path for each volume. If you do not explicitly specify any database path for a volume, they are accessible from the cluster through the default S3/object store segment. See segment_configurations below.
     */
    @JvmName("atukkrubnyfjyicf")
    public suspend fun segmentConfigurations(values: List<Output<KxDataviewSegmentConfigurationArgs>>) {
        this.segmentConfigurations = Output.all(values)
    }

    /**
     * @param value Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("jurionxemysmfjki")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The option to specify whether you want to apply all the future additions and corrections automatically to the dataview, when you ingest new changesets. The default value is false.
     */
    @JvmName("nqyldlaksfbkbpyl")
    public suspend fun autoUpdate(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoUpdate = mapped
    }

    /**
     * @param value The identifier of the availability zones. If attaching a volume, the volume must be in the same availability zone as the dataview that you are attaching to.
     */
    @JvmName("nbmrhdbkxphoethf")
    public suspend fun availabilityZoneId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.availabilityZoneId = mapped
    }

    /**
     * @param value The number of availability zones you want to assign per cluster. This can be one of the following:
     * * `SINGLE` - Assigns one availability zone per cluster.
     * * `MULTI` - Assigns all the availability zones per cluster.
     */
    @JvmName("qxrpwpilnijfwwoc")
    public suspend fun azMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.azMode = mapped
    }

    /**
     * @param value A unique identifier of the changeset of the database that you want to use to ingest data.
     */
    @JvmName("mbjjpnnwcvehcmvu")
    public suspend fun changesetId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.changesetId = mapped
    }

    /**
     * @param value The name of the database where you want to create a dataview.
     */
    @JvmName("koxymkjucboibojf")
    public suspend fun databaseName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.databaseName = mapped
    }

    /**
     * @param value A description for the dataview.
     */
    @JvmName("ybeloebhphreirxb")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Unique identifier for the KX environment.
     */
    @JvmName("ioquhsymubogsrlc")
    public suspend fun environmentId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.environmentId = mapped
    }

    /**
     * @param value A unique identifier for the dataview.
     * The following arguments are optional:
     */
    @JvmName("aktkxdbpwnxyuksh")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The option to specify whether you want to make the dataview writable to perform database maintenance. The following are some considerations related to writable dataviews.
     * * You cannot create partial writable dataviews. When you create writeable dataviews you must provide the entire database path. You cannot perform updates on a writeable dataview. Hence, `auto_update` must be set as `false` if `read_write` is `true` for a dataview.
     * * You must also use a unique volume for creating a writeable dataview. So, if you choose a volume that is already in use by another dataview, the dataview creation fails.
     * * Once you create a dataview as writeable, you cannot change it to read-only. So, you cannot update the `read_write` parameter later.
     */
    @JvmName("ndwciuswgflbsebg")
    public suspend fun readWrite(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.readWrite = mapped
    }

    /**
     * @param value The configuration that contains the database path of the data that you want to place on each selected volume. Each segment must have a unique database path for each volume. If you do not explicitly specify any database path for a volume, they are accessible from the cluster through the default S3/object store segment. See segment_configurations below.
     */
    @JvmName("fsjhgrsdcxgsjjmx")
    public suspend fun segmentConfigurations(`value`: List<KxDataviewSegmentConfigurationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.segmentConfigurations = mapped
    }

    /**
     * @param argument The configuration that contains the database path of the data that you want to place on each selected volume. Each segment must have a unique database path for each volume. If you do not explicitly specify any database path for a volume, they are accessible from the cluster through the default S3/object store segment. See segment_configurations below.
     */
    @JvmName("bxsaqylpjexglrwa")
    public suspend fun segmentConfigurations(argument: List<suspend KxDataviewSegmentConfigurationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            KxDataviewSegmentConfigurationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.segmentConfigurations = mapped
    }

    /**
     * @param argument The configuration that contains the database path of the data that you want to place on each selected volume. Each segment must have a unique database path for each volume. If you do not explicitly specify any database path for a volume, they are accessible from the cluster through the default S3/object store segment. See segment_configurations below.
     */
    @JvmName("xipwjlrbdqlhbslv")
    public suspend fun segmentConfigurations(vararg argument: suspend KxDataviewSegmentConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            KxDataviewSegmentConfigurationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.segmentConfigurations = mapped
    }

    /**
     * @param argument The configuration that contains the database path of the data that you want to place on each selected volume. Each segment must have a unique database path for each volume. If you do not explicitly specify any database path for a volume, they are accessible from the cluster through the default S3/object store segment. See segment_configurations below.
     */
    @JvmName("atotosbnicqebjyo")
    public suspend fun segmentConfigurations(argument: suspend KxDataviewSegmentConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            KxDataviewSegmentConfigurationArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.segmentConfigurations = mapped
    }

    /**
     * @param values The configuration that contains the database path of the data that you want to place on each selected volume. Each segment must have a unique database path for each volume. If you do not explicitly specify any database path for a volume, they are accessible from the cluster through the default S3/object store segment. See segment_configurations below.
     */
    @JvmName("ctcjvgigjgexqksb")
    public suspend fun segmentConfigurations(vararg values: KxDataviewSegmentConfigurationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.segmentConfigurations = mapped
    }

    /**
     * @param value Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("aurujtvlvybnxbfl")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("xwxknmoysrvpxnrc")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): KxDataviewArgs = KxDataviewArgs(
        autoUpdate = autoUpdate,
        availabilityZoneId = availabilityZoneId,
        azMode = azMode,
        changesetId = changesetId,
        databaseName = databaseName,
        description = description,
        environmentId = environmentId,
        name = name,
        readWrite = readWrite,
        segmentConfigurations = segmentConfigurations,
        tags = tags,
    )
}
