@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.finspace.kotlin

import com.pulumi.aws.finspace.kotlin.outputs.KxEnvironmentCustomDnsConfiguration
import com.pulumi.aws.finspace.kotlin.outputs.KxEnvironmentTransitGatewayConfiguration
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.finspace.kotlin.outputs.KxEnvironmentCustomDnsConfiguration.Companion.toKotlin as kxEnvironmentCustomDnsConfigurationToKotlin
import com.pulumi.aws.finspace.kotlin.outputs.KxEnvironmentTransitGatewayConfiguration.Companion.toKotlin as kxEnvironmentTransitGatewayConfigurationToKotlin

/**
 * Builder for [KxEnvironment].
 */
@PulumiTagMarker
public class KxEnvironmentResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: KxEnvironmentArgs = KxEnvironmentArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend KxEnvironmentArgsBuilder.() -> Unit) {
        val builder = KxEnvironmentArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): KxEnvironment {
        val builtJavaResource = com.pulumi.aws.finspace.KxEnvironment(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return KxEnvironment(builtJavaResource)
    }
}

/**
 * Resource for managing an AWS FinSpace Kx Environment.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.kms.Key("example", {
 *     description: "Sample KMS Key",
 *     deletionWindowInDays: 7,
 * });
 * const exampleKxEnvironment = new aws.finspace.KxEnvironment("example", {
 *     name: "my-tf-kx-environment",
 *     kmsKeyId: example.arn,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.kms.Key("example",
 *     description="Sample KMS Key",
 *     deletion_window_in_days=7)
 * example_kx_environment = aws.finspace.KxEnvironment("example",
 *     name="my-tf-kx-environment",
 *     kms_key_id=example.arn)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Kms.Key("example", new()
 *     {
 *         Description = "Sample KMS Key",
 *         DeletionWindowInDays = 7,
 *     });
 *     var exampleKxEnvironment = new Aws.FinSpace.KxEnvironment("example", new()
 *     {
 *         Name = "my-tf-kx-environment",
 *         KmsKeyId = example.Arn,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/finspace"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/kms"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := kms.NewKey(ctx, "example", &kms.KeyArgs{
 * 			Description:          pulumi.String("Sample KMS Key"),
 * 			DeletionWindowInDays: pulumi.Int(7),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = finspace.NewKxEnvironment(ctx, "example", &finspace.KxEnvironmentArgs{
 * 			Name:     pulumi.String("my-tf-kx-environment"),
 * 			KmsKeyId: example.Arn,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.kms.Key;
 * import com.pulumi.aws.kms.KeyArgs;
 * import com.pulumi.aws.finspace.KxEnvironment;
 * import com.pulumi.aws.finspace.KxEnvironmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Key("example", KeyArgs.builder()
 *             .description("Sample KMS Key")
 *             .deletionWindowInDays(7)
 *             .build());
 *         var exampleKxEnvironment = new KxEnvironment("exampleKxEnvironment", KxEnvironmentArgs.builder()
 *             .name("my-tf-kx-environment")
 *             .kmsKeyId(example.arn())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:kms:Key
 *     properties:
 *       description: Sample KMS Key
 *       deletionWindowInDays: 7
 *   exampleKxEnvironment:
 *     type: aws:finspace:KxEnvironment
 *     name: example
 *     properties:
 *       name: my-tf-kx-environment
 *       kmsKeyId: ${example.arn}
 * ```
 * <!--End PulumiCodeChooser -->
 * ### With Transit Gateway Configuration
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.kms.Key("example", {
 *     description: "Sample KMS Key",
 *     deletionWindowInDays: 7,
 * });
 * const exampleTransitGateway = new aws.ec2transitgateway.TransitGateway("example", {description: "example"});
 * const exampleEnv = new aws.finspace.KxEnvironment("example_env", {
 *     name: "my-tf-kx-environment",
 *     description: "Environment description",
 *     kmsKeyId: example.arn,
 *     transitGatewayConfiguration: {
 *         transitGatewayId: exampleTransitGateway.id,
 *         routableCidrSpace: "100.64.0.0/26",
 *     },
 *     customDnsConfigurations: [{
 *         customDnsServerName: "example.finspace.amazonaws.com",
 *         customDnsServerIp: "10.0.0.76",
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.kms.Key("example",
 *     description="Sample KMS Key",
 *     deletion_window_in_days=7)
 * example_transit_gateway = aws.ec2transitgateway.TransitGateway("example", description="example")
 * example_env = aws.finspace.KxEnvironment("example_env",
 *     name="my-tf-kx-environment",
 *     description="Environment description",
 *     kms_key_id=example.arn,
 *     transit_gateway_configuration={
 *         "transit_gateway_id": example_transit_gateway.id,
 *         "routable_cidr_space": "100.64.0.0/26",
 *     },
 *     custom_dns_configurations=[{
 *         "custom_dns_server_name": "example.finspace.amazonaws.com",
 *         "custom_dns_server_ip": "10.0.0.76",
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Kms.Key("example", new()
 *     {
 *         Description = "Sample KMS Key",
 *         DeletionWindowInDays = 7,
 *     });
 *     var exampleTransitGateway = new Aws.Ec2TransitGateway.TransitGateway("example", new()
 *     {
 *         Description = "example",
 *     });
 *     var exampleEnv = new Aws.FinSpace.KxEnvironment("example_env", new()
 *     {
 *         Name = "my-tf-kx-environment",
 *         Description = "Environment description",
 *         KmsKeyId = example.Arn,
 *         TransitGatewayConfiguration = new Aws.FinSpace.Inputs.KxEnvironmentTransitGatewayConfigurationArgs
 *         {
 *             TransitGatewayId = exampleTransitGateway.Id,
 *             RoutableCidrSpace = "100.64.0.0/26",
 *         },
 *         CustomDnsConfigurations = new[]
 *         {
 *             new Aws.FinSpace.Inputs.KxEnvironmentCustomDnsConfigurationArgs
 *             {
 *                 CustomDnsServerName = "example.finspace.amazonaws.com",
 *                 CustomDnsServerIp = "10.0.0.76",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2transitgateway"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/finspace"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/kms"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := kms.NewKey(ctx, "example", &kms.KeyArgs{
 * 			Description:          pulumi.String("Sample KMS Key"),
 * 			DeletionWindowInDays: pulumi.Int(7),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleTransitGateway, err := ec2transitgateway.NewTransitGateway(ctx, "example", &ec2transitgateway.TransitGatewayArgs{
 * 			Description: pulumi.String("example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = finspace.NewKxEnvironment(ctx, "example_env", &finspace.KxEnvironmentArgs{
 * 			Name:        pulumi.String("my-tf-kx-environment"),
 * 			Description: pulumi.String("Environment description"),
 * 			KmsKeyId:    example.Arn,
 * 			TransitGatewayConfiguration: &finspace.KxEnvironmentTransitGatewayConfigurationArgs{
 * 				TransitGatewayId:  exampleTransitGateway.ID(),
 * 				RoutableCidrSpace: pulumi.String("100.64.0.0/26"),
 * 			},
 * 			CustomDnsConfigurations: finspace.KxEnvironmentCustomDnsConfigurationArray{
 * 				&finspace.KxEnvironmentCustomDnsConfigurationArgs{
 * 					CustomDnsServerName: pulumi.String("example.finspace.amazonaws.com"),
 * 					CustomDnsServerIp:   pulumi.String("10.0.0.76"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.kms.Key;
 * import com.pulumi.aws.kms.KeyArgs;
 * import com.pulumi.aws.ec2transitgateway.TransitGateway;
 * import com.pulumi.aws.ec2transitgateway.TransitGatewayArgs;
 * import com.pulumi.aws.finspace.KxEnvironment;
 * import com.pulumi.aws.finspace.KxEnvironmentArgs;
 * import com.pulumi.aws.finspace.inputs.KxEnvironmentTransitGatewayConfigurationArgs;
 * import com.pulumi.aws.finspace.inputs.KxEnvironmentCustomDnsConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Key("example", KeyArgs.builder()
 *             .description("Sample KMS Key")
 *             .deletionWindowInDays(7)
 *             .build());
 *         var exampleTransitGateway = new TransitGateway("exampleTransitGateway", TransitGatewayArgs.builder()
 *             .description("example")
 *             .build());
 *         var exampleEnv = new KxEnvironment("exampleEnv", KxEnvironmentArgs.builder()
 *             .name("my-tf-kx-environment")
 *             .description("Environment description")
 *             .kmsKeyId(example.arn())
 *             .transitGatewayConfiguration(KxEnvironmentTransitGatewayConfigurationArgs.builder()
 *                 .transitGatewayId(exampleTransitGateway.id())
 *                 .routableCidrSpace("100.64.0.0/26")
 *                 .build())
 *             .customDnsConfigurations(KxEnvironmentCustomDnsConfigurationArgs.builder()
 *                 .customDnsServerName("example.finspace.amazonaws.com")
 *                 .customDnsServerIp("10.0.0.76")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:kms:Key
 *     properties:
 *       description: Sample KMS Key
 *       deletionWindowInDays: 7
 *   exampleTransitGateway:
 *     type: aws:ec2transitgateway:TransitGateway
 *     name: example
 *     properties:
 *       description: example
 *   exampleEnv:
 *     type: aws:finspace:KxEnvironment
 *     name: example_env
 *     properties:
 *       name: my-tf-kx-environment
 *       description: Environment description
 *       kmsKeyId: ${example.arn}
 *       transitGatewayConfiguration:
 *         transitGatewayId: ${exampleTransitGateway.id}
 *         routableCidrSpace: 100.64.0.0/26
 *       customDnsConfigurations:
 *         - customDnsServerName: example.finspace.amazonaws.com
 *           customDnsServerIp: 10.0.0.76
 * ```
 * <!--End PulumiCodeChooser -->
 * ### With Transit Gateway Attachment Network ACL Configuration
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.kms.Key("example", {
 *     description: "Sample KMS Key",
 *     deletionWindowInDays: 7,
 * });
 * const exampleTransitGateway = new aws.ec2transitgateway.TransitGateway("example", {description: "example"});
 * const exampleEnv = new aws.finspace.KxEnvironment("example_env", {
 *     name: "my-tf-kx-environment",
 *     description: "Environment description",
 *     kmsKeyId: example.arn,
 *     transitGatewayConfiguration: {
 *         transitGatewayId: exampleTransitGateway.id,
 *         routableCidrSpace: "100.64.0.0/26",
 *         attachmentNetworkAclConfigurations: [{
 *             ruleNumber: 1,
 *             protocol: "6",
 *             ruleAction: "allow",
 *             cidrBlock: "0.0.0.0/0",
 *             portRange: {
 *                 from: 53,
 *                 to: 53,
 *             },
 *             icmpTypeCode: {
 *                 type: -1,
 *                 code: -1,
 *             },
 *         }],
 *     },
 *     customDnsConfigurations: [{
 *         customDnsServerName: "example.finspace.amazonaws.com",
 *         customDnsServerIp: "10.0.0.76",
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.kms.Key("example",
 *     description="Sample KMS Key",
 *     deletion_window_in_days=7)
 * example_transit_gateway = aws.ec2transitgateway.TransitGateway("example", description="example")
 * example_env = aws.finspace.KxEnvironment("example_env",
 *     name="my-tf-kx-environment",
 *     description="Environment description",
 *     kms_key_id=example.arn,
 *     transit_gateway_configuration={
 *         "transit_gateway_id": example_transit_gateway.id,
 *         "routable_cidr_space": "100.64.0.0/26",
 *         "attachment_network_acl_configurations": [{
 *             "rule_number": 1,
 *             "protocol": "6",
 *             "rule_action": "allow",
 *             "cidr_block": "0.0.0.0/0",
 *             "port_range": {
 *                 "from_": 53,
 *                 "to": 53,
 *             },
 *             "icmp_type_code": {
 *                 "type": -1,
 *                 "code": -1,
 *             },
 *         }],
 *     },
 *     custom_dns_configurations=[{
 *         "custom_dns_server_name": "example.finspace.amazonaws.com",
 *         "custom_dns_server_ip": "10.0.0.76",
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Kms.Key("example", new()
 *     {
 *         Description = "Sample KMS Key",
 *         DeletionWindowInDays = 7,
 *     });
 *     var exampleTransitGateway = new Aws.Ec2TransitGateway.TransitGateway("example", new()
 *     {
 *         Description = "example",
 *     });
 *     var exampleEnv = new Aws.FinSpace.KxEnvironment("example_env", new()
 *     {
 *         Name = "my-tf-kx-environment",
 *         Description = "Environment description",
 *         KmsKeyId = example.Arn,
 *         TransitGatewayConfiguration = new Aws.FinSpace.Inputs.KxEnvironmentTransitGatewayConfigurationArgs
 *         {
 *             TransitGatewayId = exampleTransitGateway.Id,
 *             RoutableCidrSpace = "100.64.0.0/26",
 *             AttachmentNetworkAclConfigurations = new[]
 *             {
 *                 new Aws.FinSpace.Inputs.KxEnvironmentTransitGatewayConfigurationAttachmentNetworkAclConfigurationArgs
 *                 {
 *                     RuleNumber = 1,
 *                     Protocol = "6",
 *                     RuleAction = "allow",
 *                     CidrBlock = "0.0.0.0/0",
 *                     PortRange = new Aws.FinSpace.Inputs.KxEnvironmentTransitGatewayConfigurationAttachmentNetworkAclConfigurationPortRangeArgs
 *                     {
 *                         From = 53,
 *                         To = 53,
 *                     },
 *                     IcmpTypeCode = new Aws.FinSpace.Inputs.KxEnvironmentTransitGatewayConfigurationAttachmentNetworkAclConfigurationIcmpTypeCodeArgs
 *                     {
 *                         Type = -1,
 *                         Code = -1,
 *                     },
 *                 },
 *             },
 *         },
 *         CustomDnsConfigurations = new[]
 *         {
 *             new Aws.FinSpace.Inputs.KxEnvironmentCustomDnsConfigurationArgs
 *             {
 *                 CustomDnsServerName = "example.finspace.amazonaws.com",
 *                 CustomDnsServerIp = "10.0.0.76",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2transitgateway"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/finspace"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/kms"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := kms.NewKey(ctx, "example", &kms.KeyArgs{
 * 			Description:          pulumi.String("Sample KMS Key"),
 * 			DeletionWindowInDays: pulumi.Int(7),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleTransitGateway, err := ec2transitgateway.NewTransitGateway(ctx, "example", &ec2transitgateway.TransitGatewayArgs{
 * 			Description: pulumi.String("example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = finspace.NewKxEnvironment(ctx, "example_env", &finspace.KxEnvironmentArgs{
 * 			Name:        pulumi.String("my-tf-kx-environment"),
 * 			Description: pulumi.String("Environment description"),
 * 			KmsKeyId:    example.Arn,
 * 			TransitGatewayConfiguration: &finspace.KxEnvironmentTransitGatewayConfigurationArgs{
 * 				TransitGatewayId:  exampleTransitGateway.ID(),
 * 				RoutableCidrSpace: pulumi.String("100.64.0.0/26"),
 * 				AttachmentNetworkAclConfigurations: finspace.KxEnvironmentTransitGatewayConfigurationAttachmentNetworkAclConfigurationArray{
 * 					&finspace.KxEnvironmentTransitGatewayConfigurationAttachmentNetworkAclConfigurationArgs{
 * 						RuleNumber: pulumi.Int(1),
 * 						Protocol:   pulumi.String("6"),
 * 						RuleAction: pulumi.String("allow"),
 * 						CidrBlock:  pulumi.String("0.0.0.0/0"),
 * 						PortRange: &finspace.KxEnvironmentTransitGatewayConfigurationAttachmentNetworkAclConfigurationPortRangeArgs{
 * 							From: pulumi.Int(53),
 * 							To:   pulumi.Int(53),
 * 						},
 * 						IcmpTypeCode: &finspace.KxEnvironmentTransitGatewayConfigurationAttachmentNetworkAclConfigurationIcmpTypeCodeArgs{
 * 							Type: int(-1),
 * 							Code: int(-1),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			CustomDnsConfigurations: finspace.KxEnvironmentCustomDnsConfigurationArray{
 * 				&finspace.KxEnvironmentCustomDnsConfigurationArgs{
 * 					CustomDnsServerName: pulumi.String("example.finspace.amazonaws.com"),
 * 					CustomDnsServerIp:   pulumi.String("10.0.0.76"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:kms:Key
 *     properties:
 *       description: Sample KMS Key
 *       deletionWindowInDays: 7
 *   exampleTransitGateway:
 *     type: aws:ec2transitgateway:TransitGateway
 *     name: example
 *     properties:
 *       description: example
 *   exampleEnv:
 *     type: aws:finspace:KxEnvironment
 *     name: example_env
 *     properties:
 *       name: my-tf-kx-environment
 *       description: Environment description
 *       kmsKeyId: ${example.arn}
 *       transitGatewayConfiguration:
 *         transitGatewayId: ${exampleTransitGateway.id}
 *         routableCidrSpace: 100.64.0.0/26
 *         attachmentNetworkAclConfigurations:
 *           - ruleNumber: 1
 *             protocol: '6'
 *             ruleAction: allow
 *             cidrBlock: 0.0.0.0/0
 *             portRange:
 *               from: 53
 *               to: 53
 *             icmpTypeCode:
 *               type: -1
 *               code: -1
 *       customDnsConfigurations:
 *         - customDnsServerName: example.finspace.amazonaws.com
 *           customDnsServerIp: 10.0.0.76
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import an AWS FinSpace Kx Environment using the `id`. For example:
 * ```sh
 * $ pulumi import aws:finspace/kxEnvironment:KxEnvironment example n3ceo7wqxoxcti5tujqwzs
 * ```
 */
public class KxEnvironment internal constructor(
    override val javaResource: com.pulumi.aws.finspace.KxEnvironment,
) : KotlinCustomResource(javaResource, KxEnvironmentMapper) {
    /**
     * Amazon Resource Name (ARN) identifier of the KX environment.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * AWS Availability Zone IDs that this environment is available in. Important when selecting VPC subnets to use in cluster creation.
     */
    public val availabilityZones: Output<List<String>>
        get() = javaResource.availabilityZones().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * Timestamp at which the environment is created in FinSpace. Value determined as epoch time in seconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000.
     */
    public val createdTimestamp: Output<String>
        get() = javaResource.createdTimestamp().applyValue({ args0 -> args0 })

    /**
     * List of DNS server name and server IP. This is used to set up Route-53 outbound resolvers. Defined below.
     */
    public val customDnsConfigurations: Output<List<KxEnvironmentCustomDnsConfiguration>>?
        get() = javaResource.customDnsConfigurations().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        kxEnvironmentCustomDnsConfigurationToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * Description for the KX environment.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Unique identifier for the AWS environment infrastructure account.
     */
    public val infrastructureAccountId: Output<String>
        get() = javaResource.infrastructureAccountId().applyValue({ args0 -> args0 })

    /**
     * KMS key ID to encrypt your data in the FinSpace environment.
     * The following arguments are optional:
     */
    public val kmsKeyId: Output<String>
        get() = javaResource.kmsKeyId().applyValue({ args0 -> args0 })

    /**
     * Last timestamp at which the environment was updated in FinSpace. Value determined as epoch time in seconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000.
     */
    public val lastModifiedTimestamp: Output<String>
        get() = javaResource.lastModifiedTimestamp().applyValue({ args0 -> args0 })

    /**
     * Name of the KX environment that you want to create.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Status of environment creation
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * Transit gateway and network configuration that is used to connect the KX environment to an internal network. Defined below.
     */
    public val transitGatewayConfiguration: Output<KxEnvironmentTransitGatewayConfiguration>?
        get() = javaResource.transitGatewayConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    kxEnvironmentTransitGatewayConfigurationToKotlin(args0)
                })
            }).orElse(null)
        })
}

public object KxEnvironmentMapper : ResourceMapper<KxEnvironment> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.finspace.KxEnvironment::class == javaResource::class

    override fun map(javaResource: Resource): KxEnvironment = KxEnvironment(
        javaResource as
            com.pulumi.aws.finspace.KxEnvironment,
    )
}

/**
 * @see [KxEnvironment].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [KxEnvironment].
 */
public suspend fun kxEnvironment(
    name: String,
    block: suspend KxEnvironmentResourceBuilder.() -> Unit,
): KxEnvironment {
    val builder = KxEnvironmentResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [KxEnvironment].
 * @param name The _unique_ name of the resulting resource.
 */
public fun kxEnvironment(name: String): KxEnvironment {
    val builder = KxEnvironmentResourceBuilder()
    builder.name(name)
    return builder.build()
}
