@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.finspace.kotlin

import com.pulumi.aws.finspace.KxEnvironmentArgs.builder
import com.pulumi.aws.finspace.kotlin.inputs.KxEnvironmentCustomDnsConfigurationArgs
import com.pulumi.aws.finspace.kotlin.inputs.KxEnvironmentCustomDnsConfigurationArgsBuilder
import com.pulumi.aws.finspace.kotlin.inputs.KxEnvironmentTransitGatewayConfigurationArgs
import com.pulumi.aws.finspace.kotlin.inputs.KxEnvironmentTransitGatewayConfigurationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS FinSpace Kx Environment.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.kms.Key("example", {
 *     description: "Sample KMS Key",
 *     deletionWindowInDays: 7,
 * });
 * const exampleKxEnvironment = new aws.finspace.KxEnvironment("example", {
 *     name: "my-tf-kx-environment",
 *     kmsKeyId: example.arn,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.kms.Key("example",
 *     description="Sample KMS Key",
 *     deletion_window_in_days=7)
 * example_kx_environment = aws.finspace.KxEnvironment("example",
 *     name="my-tf-kx-environment",
 *     kms_key_id=example.arn)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Kms.Key("example", new()
 *     {
 *         Description = "Sample KMS Key",
 *         DeletionWindowInDays = 7,
 *     });
 *     var exampleKxEnvironment = new Aws.FinSpace.KxEnvironment("example", new()
 *     {
 *         Name = "my-tf-kx-environment",
 *         KmsKeyId = example.Arn,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/finspace"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/kms"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := kms.NewKey(ctx, "example", &kms.KeyArgs{
 * 			Description:          pulumi.String("Sample KMS Key"),
 * 			DeletionWindowInDays: pulumi.Int(7),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = finspace.NewKxEnvironment(ctx, "example", &finspace.KxEnvironmentArgs{
 * 			Name:     pulumi.String("my-tf-kx-environment"),
 * 			KmsKeyId: example.Arn,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.kms.Key;
 * import com.pulumi.aws.kms.KeyArgs;
 * import com.pulumi.aws.finspace.KxEnvironment;
 * import com.pulumi.aws.finspace.KxEnvironmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Key("example", KeyArgs.builder()
 *             .description("Sample KMS Key")
 *             .deletionWindowInDays(7)
 *             .build());
 *         var exampleKxEnvironment = new KxEnvironment("exampleKxEnvironment", KxEnvironmentArgs.builder()
 *             .name("my-tf-kx-environment")
 *             .kmsKeyId(example.arn())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:kms:Key
 *     properties:
 *       description: Sample KMS Key
 *       deletionWindowInDays: 7
 *   exampleKxEnvironment:
 *     type: aws:finspace:KxEnvironment
 *     name: example
 *     properties:
 *       name: my-tf-kx-environment
 *       kmsKeyId: ${example.arn}
 * ```
 * <!--End PulumiCodeChooser -->
 * ### With Transit Gateway Configuration
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.kms.Key("example", {
 *     description: "Sample KMS Key",
 *     deletionWindowInDays: 7,
 * });
 * const exampleTransitGateway = new aws.ec2transitgateway.TransitGateway("example", {description: "example"});
 * const exampleEnv = new aws.finspace.KxEnvironment("example_env", {
 *     name: "my-tf-kx-environment",
 *     description: "Environment description",
 *     kmsKeyId: example.arn,
 *     transitGatewayConfiguration: {
 *         transitGatewayId: exampleTransitGateway.id,
 *         routableCidrSpace: "100.64.0.0/26",
 *     },
 *     customDnsConfigurations: [{
 *         customDnsServerName: "example.finspace.amazonaws.com",
 *         customDnsServerIp: "10.0.0.76",
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.kms.Key("example",
 *     description="Sample KMS Key",
 *     deletion_window_in_days=7)
 * example_transit_gateway = aws.ec2transitgateway.TransitGateway("example", description="example")
 * example_env = aws.finspace.KxEnvironment("example_env",
 *     name="my-tf-kx-environment",
 *     description="Environment description",
 *     kms_key_id=example.arn,
 *     transit_gateway_configuration={
 *         "transit_gateway_id": example_transit_gateway.id,
 *         "routable_cidr_space": "100.64.0.0/26",
 *     },
 *     custom_dns_configurations=[{
 *         "custom_dns_server_name": "example.finspace.amazonaws.com",
 *         "custom_dns_server_ip": "10.0.0.76",
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Kms.Key("example", new()
 *     {
 *         Description = "Sample KMS Key",
 *         DeletionWindowInDays = 7,
 *     });
 *     var exampleTransitGateway = new Aws.Ec2TransitGateway.TransitGateway("example", new()
 *     {
 *         Description = "example",
 *     });
 *     var exampleEnv = new Aws.FinSpace.KxEnvironment("example_env", new()
 *     {
 *         Name = "my-tf-kx-environment",
 *         Description = "Environment description",
 *         KmsKeyId = example.Arn,
 *         TransitGatewayConfiguration = new Aws.FinSpace.Inputs.KxEnvironmentTransitGatewayConfigurationArgs
 *         {
 *             TransitGatewayId = exampleTransitGateway.Id,
 *             RoutableCidrSpace = "100.64.0.0/26",
 *         },
 *         CustomDnsConfigurations = new[]
 *         {
 *             new Aws.FinSpace.Inputs.KxEnvironmentCustomDnsConfigurationArgs
 *             {
 *                 CustomDnsServerName = "example.finspace.amazonaws.com",
 *                 CustomDnsServerIp = "10.0.0.76",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2transitgateway"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/finspace"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/kms"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := kms.NewKey(ctx, "example", &kms.KeyArgs{
 * 			Description:          pulumi.String("Sample KMS Key"),
 * 			DeletionWindowInDays: pulumi.Int(7),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleTransitGateway, err := ec2transitgateway.NewTransitGateway(ctx, "example", &ec2transitgateway.TransitGatewayArgs{
 * 			Description: pulumi.String("example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = finspace.NewKxEnvironment(ctx, "example_env", &finspace.KxEnvironmentArgs{
 * 			Name:        pulumi.String("my-tf-kx-environment"),
 * 			Description: pulumi.String("Environment description"),
 * 			KmsKeyId:    example.Arn,
 * 			TransitGatewayConfiguration: &finspace.KxEnvironmentTransitGatewayConfigurationArgs{
 * 				TransitGatewayId:  exampleTransitGateway.ID(),
 * 				RoutableCidrSpace: pulumi.String("100.64.0.0/26"),
 * 			},
 * 			CustomDnsConfigurations: finspace.KxEnvironmentCustomDnsConfigurationArray{
 * 				&finspace.KxEnvironmentCustomDnsConfigurationArgs{
 * 					CustomDnsServerName: pulumi.String("example.finspace.amazonaws.com"),
 * 					CustomDnsServerIp:   pulumi.String("10.0.0.76"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.kms.Key;
 * import com.pulumi.aws.kms.KeyArgs;
 * import com.pulumi.aws.ec2transitgateway.TransitGateway;
 * import com.pulumi.aws.ec2transitgateway.TransitGatewayArgs;
 * import com.pulumi.aws.finspace.KxEnvironment;
 * import com.pulumi.aws.finspace.KxEnvironmentArgs;
 * import com.pulumi.aws.finspace.inputs.KxEnvironmentTransitGatewayConfigurationArgs;
 * import com.pulumi.aws.finspace.inputs.KxEnvironmentCustomDnsConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Key("example", KeyArgs.builder()
 *             .description("Sample KMS Key")
 *             .deletionWindowInDays(7)
 *             .build());
 *         var exampleTransitGateway = new TransitGateway("exampleTransitGateway", TransitGatewayArgs.builder()
 *             .description("example")
 *             .build());
 *         var exampleEnv = new KxEnvironment("exampleEnv", KxEnvironmentArgs.builder()
 *             .name("my-tf-kx-environment")
 *             .description("Environment description")
 *             .kmsKeyId(example.arn())
 *             .transitGatewayConfiguration(KxEnvironmentTransitGatewayConfigurationArgs.builder()
 *                 .transitGatewayId(exampleTransitGateway.id())
 *                 .routableCidrSpace("100.64.0.0/26")
 *                 .build())
 *             .customDnsConfigurations(KxEnvironmentCustomDnsConfigurationArgs.builder()
 *                 .customDnsServerName("example.finspace.amazonaws.com")
 *                 .customDnsServerIp("10.0.0.76")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:kms:Key
 *     properties:
 *       description: Sample KMS Key
 *       deletionWindowInDays: 7
 *   exampleTransitGateway:
 *     type: aws:ec2transitgateway:TransitGateway
 *     name: example
 *     properties:
 *       description: example
 *   exampleEnv:
 *     type: aws:finspace:KxEnvironment
 *     name: example_env
 *     properties:
 *       name: my-tf-kx-environment
 *       description: Environment description
 *       kmsKeyId: ${example.arn}
 *       transitGatewayConfiguration:
 *         transitGatewayId: ${exampleTransitGateway.id}
 *         routableCidrSpace: 100.64.0.0/26
 *       customDnsConfigurations:
 *         - customDnsServerName: example.finspace.amazonaws.com
 *           customDnsServerIp: 10.0.0.76
 * ```
 * <!--End PulumiCodeChooser -->
 * ### With Transit Gateway Attachment Network ACL Configuration
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.kms.Key("example", {
 *     description: "Sample KMS Key",
 *     deletionWindowInDays: 7,
 * });
 * const exampleTransitGateway = new aws.ec2transitgateway.TransitGateway("example", {description: "example"});
 * const exampleEnv = new aws.finspace.KxEnvironment("example_env", {
 *     name: "my-tf-kx-environment",
 *     description: "Environment description",
 *     kmsKeyId: example.arn,
 *     transitGatewayConfiguration: {
 *         transitGatewayId: exampleTransitGateway.id,
 *         routableCidrSpace: "100.64.0.0/26",
 *         attachmentNetworkAclConfigurations: [{
 *             ruleNumber: 1,
 *             protocol: "6",
 *             ruleAction: "allow",
 *             cidrBlock: "0.0.0.0/0",
 *             portRange: {
 *                 from: 53,
 *                 to: 53,
 *             },
 *             icmpTypeCode: {
 *                 type: -1,
 *                 code: -1,
 *             },
 *         }],
 *     },
 *     customDnsConfigurations: [{
 *         customDnsServerName: "example.finspace.amazonaws.com",
 *         customDnsServerIp: "10.0.0.76",
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.kms.Key("example",
 *     description="Sample KMS Key",
 *     deletion_window_in_days=7)
 * example_transit_gateway = aws.ec2transitgateway.TransitGateway("example", description="example")
 * example_env = aws.finspace.KxEnvironment("example_env",
 *     name="my-tf-kx-environment",
 *     description="Environment description",
 *     kms_key_id=example.arn,
 *     transit_gateway_configuration={
 *         "transit_gateway_id": example_transit_gateway.id,
 *         "routable_cidr_space": "100.64.0.0/26",
 *         "attachment_network_acl_configurations": [{
 *             "rule_number": 1,
 *             "protocol": "6",
 *             "rule_action": "allow",
 *             "cidr_block": "0.0.0.0/0",
 *             "port_range": {
 *                 "from_": 53,
 *                 "to": 53,
 *             },
 *             "icmp_type_code": {
 *                 "type": -1,
 *                 "code": -1,
 *             },
 *         }],
 *     },
 *     custom_dns_configurations=[{
 *         "custom_dns_server_name": "example.finspace.amazonaws.com",
 *         "custom_dns_server_ip": "10.0.0.76",
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Kms.Key("example", new()
 *     {
 *         Description = "Sample KMS Key",
 *         DeletionWindowInDays = 7,
 *     });
 *     var exampleTransitGateway = new Aws.Ec2TransitGateway.TransitGateway("example", new()
 *     {
 *         Description = "example",
 *     });
 *     var exampleEnv = new Aws.FinSpace.KxEnvironment("example_env", new()
 *     {
 *         Name = "my-tf-kx-environment",
 *         Description = "Environment description",
 *         KmsKeyId = example.Arn,
 *         TransitGatewayConfiguration = new Aws.FinSpace.Inputs.KxEnvironmentTransitGatewayConfigurationArgs
 *         {
 *             TransitGatewayId = exampleTransitGateway.Id,
 *             RoutableCidrSpace = "100.64.0.0/26",
 *             AttachmentNetworkAclConfigurations = new[]
 *             {
 *                 new Aws.FinSpace.Inputs.KxEnvironmentTransitGatewayConfigurationAttachmentNetworkAclConfigurationArgs
 *                 {
 *                     RuleNumber = 1,
 *                     Protocol = "6",
 *                     RuleAction = "allow",
 *                     CidrBlock = "0.0.0.0/0",
 *                     PortRange = new Aws.FinSpace.Inputs.KxEnvironmentTransitGatewayConfigurationAttachmentNetworkAclConfigurationPortRangeArgs
 *                     {
 *                         From = 53,
 *                         To = 53,
 *                     },
 *                     IcmpTypeCode = new Aws.FinSpace.Inputs.KxEnvironmentTransitGatewayConfigurationAttachmentNetworkAclConfigurationIcmpTypeCodeArgs
 *                     {
 *                         Type = -1,
 *                         Code = -1,
 *                     },
 *                 },
 *             },
 *         },
 *         CustomDnsConfigurations = new[]
 *         {
 *             new Aws.FinSpace.Inputs.KxEnvironmentCustomDnsConfigurationArgs
 *             {
 *                 CustomDnsServerName = "example.finspace.amazonaws.com",
 *                 CustomDnsServerIp = "10.0.0.76",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2transitgateway"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/finspace"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/kms"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := kms.NewKey(ctx, "example", &kms.KeyArgs{
 * 			Description:          pulumi.String("Sample KMS Key"),
 * 			DeletionWindowInDays: pulumi.Int(7),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleTransitGateway, err := ec2transitgateway.NewTransitGateway(ctx, "example", &ec2transitgateway.TransitGatewayArgs{
 * 			Description: pulumi.String("example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = finspace.NewKxEnvironment(ctx, "example_env", &finspace.KxEnvironmentArgs{
 * 			Name:        pulumi.String("my-tf-kx-environment"),
 * 			Description: pulumi.String("Environment description"),
 * 			KmsKeyId:    example.Arn,
 * 			TransitGatewayConfiguration: &finspace.KxEnvironmentTransitGatewayConfigurationArgs{
 * 				TransitGatewayId:  exampleTransitGateway.ID(),
 * 				RoutableCidrSpace: pulumi.String("100.64.0.0/26"),
 * 				AttachmentNetworkAclConfigurations: finspace.KxEnvironmentTransitGatewayConfigurationAttachmentNetworkAclConfigurationArray{
 * 					&finspace.KxEnvironmentTransitGatewayConfigurationAttachmentNetworkAclConfigurationArgs{
 * 						RuleNumber: pulumi.Int(1),
 * 						Protocol:   pulumi.String("6"),
 * 						RuleAction: pulumi.String("allow"),
 * 						CidrBlock:  pulumi.String("0.0.0.0/0"),
 * 						PortRange: &finspace.KxEnvironmentTransitGatewayConfigurationAttachmentNetworkAclConfigurationPortRangeArgs{
 * 							From: pulumi.Int(53),
 * 							To:   pulumi.Int(53),
 * 						},
 * 						IcmpTypeCode: &finspace.KxEnvironmentTransitGatewayConfigurationAttachmentNetworkAclConfigurationIcmpTypeCodeArgs{
 * 							Type: int(-1),
 * 							Code: int(-1),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			CustomDnsConfigurations: finspace.KxEnvironmentCustomDnsConfigurationArray{
 * 				&finspace.KxEnvironmentCustomDnsConfigurationArgs{
 * 					CustomDnsServerName: pulumi.String("example.finspace.amazonaws.com"),
 * 					CustomDnsServerIp:   pulumi.String("10.0.0.76"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:kms:Key
 *     properties:
 *       description: Sample KMS Key
 *       deletionWindowInDays: 7
 *   exampleTransitGateway:
 *     type: aws:ec2transitgateway:TransitGateway
 *     name: example
 *     properties:
 *       description: example
 *   exampleEnv:
 *     type: aws:finspace:KxEnvironment
 *     name: example_env
 *     properties:
 *       name: my-tf-kx-environment
 *       description: Environment description
 *       kmsKeyId: ${example.arn}
 *       transitGatewayConfiguration:
 *         transitGatewayId: ${exampleTransitGateway.id}
 *         routableCidrSpace: 100.64.0.0/26
 *         attachmentNetworkAclConfigurations:
 *           - ruleNumber: 1
 *             protocol: '6'
 *             ruleAction: allow
 *             cidrBlock: 0.0.0.0/0
 *             portRange:
 *               from: 53
 *               to: 53
 *             icmpTypeCode:
 *               type: -1
 *               code: -1
 *       customDnsConfigurations:
 *         - customDnsServerName: example.finspace.amazonaws.com
 *           customDnsServerIp: 10.0.0.76
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import an AWS FinSpace Kx Environment using the `id`. For example:
 * ```sh
 * $ pulumi import aws:finspace/kxEnvironment:KxEnvironment example n3ceo7wqxoxcti5tujqwzs
 * ```
 * @property customDnsConfigurations List of DNS server name and server IP. This is used to set up Route-53 outbound resolvers. Defined below.
 * @property description Description for the KX environment.
 * @property kmsKeyId KMS key ID to encrypt your data in the FinSpace environment.
 * The following arguments are optional:
 * @property name Name of the KX environment that you want to create.
 * @property tags Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property transitGatewayConfiguration Transit gateway and network configuration that is used to connect the KX environment to an internal network. Defined below.
 */
public data class KxEnvironmentArgs(
    public val customDnsConfigurations: Output<List<KxEnvironmentCustomDnsConfigurationArgs>>? = null,
    public val description: Output<String>? = null,
    public val kmsKeyId: Output<String>? = null,
    public val name: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val transitGatewayConfiguration: Output<KxEnvironmentTransitGatewayConfigurationArgs>? =
        null,
) : ConvertibleToJava<com.pulumi.aws.finspace.KxEnvironmentArgs> {
    override fun toJava(): com.pulumi.aws.finspace.KxEnvironmentArgs =
        com.pulumi.aws.finspace.KxEnvironmentArgs.builder()
            .customDnsConfigurations(
                customDnsConfigurations?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .description(description?.applyValue({ args0 -> args0 }))
            .kmsKeyId(kmsKeyId?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .transitGatewayConfiguration(
                transitGatewayConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [KxEnvironmentArgs].
 */
@PulumiTagMarker
public class KxEnvironmentArgsBuilder internal constructor() {
    private var customDnsConfigurations: Output<List<KxEnvironmentCustomDnsConfigurationArgs>>? = null

    private var description: Output<String>? = null

    private var kmsKeyId: Output<String>? = null

    private var name: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var transitGatewayConfiguration: Output<KxEnvironmentTransitGatewayConfigurationArgs>? =
        null

    /**
     * @param value List of DNS server name and server IP. This is used to set up Route-53 outbound resolvers. Defined below.
     */
    @JvmName("afhfxqmqtcqidrnc")
    public suspend fun customDnsConfigurations(`value`: Output<List<KxEnvironmentCustomDnsConfigurationArgs>>) {
        this.customDnsConfigurations = value
    }

    @JvmName("pyynuemqovswslal")
    public suspend fun customDnsConfigurations(vararg values: Output<KxEnvironmentCustomDnsConfigurationArgs>) {
        this.customDnsConfigurations = Output.all(values.asList())
    }

    /**
     * @param values List of DNS server name and server IP. This is used to set up Route-53 outbound resolvers. Defined below.
     */
    @JvmName("ysjrujmkbbxjijwk")
    public suspend fun customDnsConfigurations(values: List<Output<KxEnvironmentCustomDnsConfigurationArgs>>) {
        this.customDnsConfigurations = Output.all(values)
    }

    /**
     * @param value Description for the KX environment.
     */
    @JvmName("cayyumrnukcivbsv")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value KMS key ID to encrypt your data in the FinSpace environment.
     * The following arguments are optional:
     */
    @JvmName("refvvktdnnyqsyfi")
    public suspend fun kmsKeyId(`value`: Output<String>) {
        this.kmsKeyId = value
    }

    /**
     * @param value Name of the KX environment that you want to create.
     */
    @JvmName("whinosrkgjsorkuq")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("cchkaxkmibcuavvt")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Transit gateway and network configuration that is used to connect the KX environment to an internal network. Defined below.
     */
    @JvmName("ylsiemjghcncbmss")
    public suspend fun transitGatewayConfiguration(`value`: Output<KxEnvironmentTransitGatewayConfigurationArgs>) {
        this.transitGatewayConfiguration = value
    }

    /**
     * @param value List of DNS server name and server IP. This is used to set up Route-53 outbound resolvers. Defined below.
     */
    @JvmName("injjvnddfsbcnvmp")
    public suspend fun customDnsConfigurations(`value`: List<KxEnvironmentCustomDnsConfigurationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customDnsConfigurations = mapped
    }

    /**
     * @param argument List of DNS server name and server IP. This is used to set up Route-53 outbound resolvers. Defined below.
     */
    @JvmName("scixmtggckqonjwi")
    public suspend fun customDnsConfigurations(argument: List<suspend KxEnvironmentCustomDnsConfigurationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            KxEnvironmentCustomDnsConfigurationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.customDnsConfigurations = mapped
    }

    /**
     * @param argument List of DNS server name and server IP. This is used to set up Route-53 outbound resolvers. Defined below.
     */
    @JvmName("rpdhmsmiqkqrddhr")
    public suspend fun customDnsConfigurations(vararg argument: suspend KxEnvironmentCustomDnsConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            KxEnvironmentCustomDnsConfigurationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.customDnsConfigurations = mapped
    }

    /**
     * @param argument List of DNS server name and server IP. This is used to set up Route-53 outbound resolvers. Defined below.
     */
    @JvmName("mninpxmmdqgxpway")
    public suspend fun customDnsConfigurations(argument: suspend KxEnvironmentCustomDnsConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            KxEnvironmentCustomDnsConfigurationArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.customDnsConfigurations = mapped
    }

    /**
     * @param values List of DNS server name and server IP. This is used to set up Route-53 outbound resolvers. Defined below.
     */
    @JvmName("meagrxwucihsfkyx")
    public suspend fun customDnsConfigurations(vararg values: KxEnvironmentCustomDnsConfigurationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.customDnsConfigurations = mapped
    }

    /**
     * @param value Description for the KX environment.
     */
    @JvmName("lnojgttqykrpidte")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value KMS key ID to encrypt your data in the FinSpace environment.
     * The following arguments are optional:
     */
    @JvmName("satvhopggyadnblq")
    public suspend fun kmsKeyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsKeyId = mapped
    }

    /**
     * @param value Name of the KX environment that you want to create.
     */
    @JvmName("ncneeaexfjbjsgxx")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("otpyorplgvrravnl")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("wstqgdfstcdmjekk")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Transit gateway and network configuration that is used to connect the KX environment to an internal network. Defined below.
     */
    @JvmName("huvjkkbaxmepdmwv")
    public suspend fun transitGatewayConfiguration(`value`: KxEnvironmentTransitGatewayConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.transitGatewayConfiguration = mapped
    }

    /**
     * @param argument Transit gateway and network configuration that is used to connect the KX environment to an internal network. Defined below.
     */
    @JvmName("tgifiounasbuvike")
    public suspend fun transitGatewayConfiguration(argument: suspend KxEnvironmentTransitGatewayConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = KxEnvironmentTransitGatewayConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.transitGatewayConfiguration = mapped
    }

    internal fun build(): KxEnvironmentArgs = KxEnvironmentArgs(
        customDnsConfigurations = customDnsConfigurations,
        description = description,
        kmsKeyId = kmsKeyId,
        name = name,
        tags = tags,
        transitGatewayConfiguration = transitGatewayConfiguration,
    )
}
