@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.finspace.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [KxScalingGroup].
 */
@PulumiTagMarker
public class KxScalingGroupResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: KxScalingGroupArgs = KxScalingGroupArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend KxScalingGroupArgsBuilder.() -> Unit) {
        val builder = KxScalingGroupArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): KxScalingGroup {
        val builtJavaResource = com.pulumi.aws.finspace.KxScalingGroup(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return KxScalingGroup(builtJavaResource)
    }
}

/**
 * Resource for managing an AWS FinSpace Kx Scaling Group.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.finspace.KxScalingGroup("example", {
 *     name: "my-tf-kx-scalinggroup",
 *     environmentId: exampleAwsFinspaceKxEnvironment.id,
 *     availabilityZoneId: "use1-az2",
 *     hostType: "kx.sg.4xlarge",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.finspace.KxScalingGroup("example",
 *     name="my-tf-kx-scalinggroup",
 *     environment_id=example_aws_finspace_kx_environment["id"],
 *     availability_zone_id="use1-az2",
 *     host_type="kx.sg.4xlarge")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.FinSpace.KxScalingGroup("example", new()
 *     {
 *         Name = "my-tf-kx-scalinggroup",
 *         EnvironmentId = exampleAwsFinspaceKxEnvironment.Id,
 *         AvailabilityZoneId = "use1-az2",
 *         HostType = "kx.sg.4xlarge",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/finspace"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := finspace.NewKxScalingGroup(ctx, "example", &finspace.KxScalingGroupArgs{
 * 			Name:               pulumi.String("my-tf-kx-scalinggroup"),
 * 			EnvironmentId:      pulumi.Any(exampleAwsFinspaceKxEnvironment.Id),
 * 			AvailabilityZoneId: pulumi.String("use1-az2"),
 * 			HostType:           pulumi.String("kx.sg.4xlarge"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.finspace.KxScalingGroup;
 * import com.pulumi.aws.finspace.KxScalingGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new KxScalingGroup("example", KxScalingGroupArgs.builder()
 *             .name("my-tf-kx-scalinggroup")
 *             .environmentId(exampleAwsFinspaceKxEnvironment.id())
 *             .availabilityZoneId("use1-az2")
 *             .hostType("kx.sg.4xlarge")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:finspace:KxScalingGroup
 *     properties:
 *       name: my-tf-kx-scalinggroup
 *       environmentId: ${exampleAwsFinspaceKxEnvironment.id}
 *       availabilityZoneId: use1-az2
 *       hostType: kx.sg.4xlarge
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import an AWS FinSpace Kx Scaling Group using the `id` (environment ID and scaling group name, comma-delimited). For example:
 * ```sh
 * $ pulumi import aws:finspace/kxScalingGroup:KxScalingGroup example n3ceo7wqxoxcti5tujqwzs,my-tf-kx-scalinggroup
 * ```
 */
public class KxScalingGroup internal constructor(
    override val javaResource: com.pulumi.aws.finspace.KxScalingGroup,
) : KotlinCustomResource(javaResource, KxScalingGroupMapper) {
    /**
     * Amazon Resource Name (ARN) identifier of the KX Scaling Group.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The availability zone identifiers for the requested regions.
     */
    public val availabilityZoneId: Output<String>
        get() = javaResource.availabilityZoneId().applyValue({ args0 -> args0 })

    /**
     * The list of Managed kdb clusters that are currently active in the given scaling group.
     */
    public val clusters: Output<List<String>>
        get() = javaResource.clusters().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The timestamp at which the scaling group was created in FinSpace. The value is determined as epoch time in milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.
     */
    public val createdTimestamp: Output<String>
        get() = javaResource.createdTimestamp().applyValue({ args0 -> args0 })

    /**
     * A unique identifier for the kdb environment, where you want to create the scaling group.
     */
    public val environmentId: Output<String>
        get() = javaResource.environmentId().applyValue({ args0 -> args0 })

    /**
     * The memory and CPU capabilities of the scaling group host on which FinSpace Managed kdb clusters will be placed.
     * The following arguments are optional:
     */
    public val hostType: Output<String>
        get() = javaResource.hostType().applyValue({ args0 -> args0 })

    /**
     * Last timestamp at which the scaling group was updated in FinSpace. Value determined as epoch time in seconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000.
     */
    public val lastModifiedTimestamp: Output<String>
        get() = javaResource.lastModifiedTimestamp().applyValue({ args0 -> args0 })

    /**
     * Unique name for the scaling group that you want to create.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The status of scaling group.
     * * `CREATING` – The scaling group creation is in progress.
     * * `CREATE_FAILED` – The scaling group creation has failed.
     * * `ACTIVE` – The scaling group is active.
     * * `UPDATING` – The scaling group is in the process of being updated.
     * * `UPDATE_FAILED` – The update action failed.
     * * `DELETING` – The scaling group is in the process of being deleted.
     * * `DELETE_FAILED` – The system failed to delete the scaling group.
     * * `DELETED` – The scaling group is successfully deleted.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * The error message when a failed state occurs.
     */
    public val statusReason: Output<String>
        get() = javaResource.statusReason().applyValue({ args0 -> args0 })

    /**
     * Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level. You can add up to 50 tags to a scaling group.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object KxScalingGroupMapper : ResourceMapper<KxScalingGroup> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.finspace.KxScalingGroup::class == javaResource::class

    override fun map(javaResource: Resource): KxScalingGroup = KxScalingGroup(
        javaResource as
            com.pulumi.aws.finspace.KxScalingGroup,
    )
}

/**
 * @see [KxScalingGroup].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [KxScalingGroup].
 */
public suspend fun kxScalingGroup(
    name: String,
    block: suspend KxScalingGroupResourceBuilder.() -> Unit,
): KxScalingGroup {
    val builder = KxScalingGroupResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [KxScalingGroup].
 * @param name The _unique_ name of the resulting resource.
 */
public fun kxScalingGroup(name: String): KxScalingGroup {
    val builder = KxScalingGroupResourceBuilder()
    builder.name(name)
    return builder.build()
}
