@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.finspace.kotlin

import com.pulumi.aws.finspace.KxScalingGroupArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS FinSpace Kx Scaling Group.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.finspace.KxScalingGroup("example", {
 *     name: "my-tf-kx-scalinggroup",
 *     environmentId: exampleAwsFinspaceKxEnvironment.id,
 *     availabilityZoneId: "use1-az2",
 *     hostType: "kx.sg.4xlarge",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.finspace.KxScalingGroup("example",
 *     name="my-tf-kx-scalinggroup",
 *     environment_id=example_aws_finspace_kx_environment["id"],
 *     availability_zone_id="use1-az2",
 *     host_type="kx.sg.4xlarge")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.FinSpace.KxScalingGroup("example", new()
 *     {
 *         Name = "my-tf-kx-scalinggroup",
 *         EnvironmentId = exampleAwsFinspaceKxEnvironment.Id,
 *         AvailabilityZoneId = "use1-az2",
 *         HostType = "kx.sg.4xlarge",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/finspace"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := finspace.NewKxScalingGroup(ctx, "example", &finspace.KxScalingGroupArgs{
 * 			Name:               pulumi.String("my-tf-kx-scalinggroup"),
 * 			EnvironmentId:      pulumi.Any(exampleAwsFinspaceKxEnvironment.Id),
 * 			AvailabilityZoneId: pulumi.String("use1-az2"),
 * 			HostType:           pulumi.String("kx.sg.4xlarge"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.finspace.KxScalingGroup;
 * import com.pulumi.aws.finspace.KxScalingGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new KxScalingGroup("example", KxScalingGroupArgs.builder()
 *             .name("my-tf-kx-scalinggroup")
 *             .environmentId(exampleAwsFinspaceKxEnvironment.id())
 *             .availabilityZoneId("use1-az2")
 *             .hostType("kx.sg.4xlarge")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:finspace:KxScalingGroup
 *     properties:
 *       name: my-tf-kx-scalinggroup
 *       environmentId: ${exampleAwsFinspaceKxEnvironment.id}
 *       availabilityZoneId: use1-az2
 *       hostType: kx.sg.4xlarge
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import an AWS FinSpace Kx Scaling Group using the `id` (environment ID and scaling group name, comma-delimited). For example:
 * ```sh
 * $ pulumi import aws:finspace/kxScalingGroup:KxScalingGroup example n3ceo7wqxoxcti5tujqwzs,my-tf-kx-scalinggroup
 * ```
 * @property availabilityZoneId The availability zone identifiers for the requested regions.
 * @property environmentId A unique identifier for the kdb environment, where you want to create the scaling group.
 * @property hostType The memory and CPU capabilities of the scaling group host on which FinSpace Managed kdb clusters will be placed.
 * The following arguments are optional:
 * @property name Unique name for the scaling group that you want to create.
 * @property tags Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level. You can add up to 50 tags to a scaling group.
 */
public data class KxScalingGroupArgs(
    public val availabilityZoneId: Output<String>? = null,
    public val environmentId: Output<String>? = null,
    public val hostType: Output<String>? = null,
    public val name: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.finspace.KxScalingGroupArgs> {
    override fun toJava(): com.pulumi.aws.finspace.KxScalingGroupArgs =
        com.pulumi.aws.finspace.KxScalingGroupArgs.builder()
            .availabilityZoneId(availabilityZoneId?.applyValue({ args0 -> args0 }))
            .environmentId(environmentId?.applyValue({ args0 -> args0 }))
            .hostType(hostType?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [KxScalingGroupArgs].
 */
@PulumiTagMarker
public class KxScalingGroupArgsBuilder internal constructor() {
    private var availabilityZoneId: Output<String>? = null

    private var environmentId: Output<String>? = null

    private var hostType: Output<String>? = null

    private var name: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The availability zone identifiers for the requested regions.
     */
    @JvmName("eojmggankeguxkqd")
    public suspend fun availabilityZoneId(`value`: Output<String>) {
        this.availabilityZoneId = value
    }

    /**
     * @param value A unique identifier for the kdb environment, where you want to create the scaling group.
     */
    @JvmName("lxxplqssmkwwwkcd")
    public suspend fun environmentId(`value`: Output<String>) {
        this.environmentId = value
    }

    /**
     * @param value The memory and CPU capabilities of the scaling group host on which FinSpace Managed kdb clusters will be placed.
     * The following arguments are optional:
     */
    @JvmName("nbrqpqsiqynlqtah")
    public suspend fun hostType(`value`: Output<String>) {
        this.hostType = value
    }

    /**
     * @param value Unique name for the scaling group that you want to create.
     */
    @JvmName("kydjsbfhvenuoqgc")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level. You can add up to 50 tags to a scaling group.
     */
    @JvmName("wsnaxfquyeewewis")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The availability zone identifiers for the requested regions.
     */
    @JvmName("aetqtmgtpfxhvlqb")
    public suspend fun availabilityZoneId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.availabilityZoneId = mapped
    }

    /**
     * @param value A unique identifier for the kdb environment, where you want to create the scaling group.
     */
    @JvmName("exhgobfjqlaflxhl")
    public suspend fun environmentId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.environmentId = mapped
    }

    /**
     * @param value The memory and CPU capabilities of the scaling group host on which FinSpace Managed kdb clusters will be placed.
     * The following arguments are optional:
     */
    @JvmName("xdxfynqbxxwrpyek")
    public suspend fun hostType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hostType = mapped
    }

    /**
     * @param value Unique name for the scaling group that you want to create.
     */
    @JvmName("ubvmfowrykhmydbr")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level. You can add up to 50 tags to a scaling group.
     */
    @JvmName("shoovtytrreuoadt")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level. You can add up to 50 tags to a scaling group.
     */
    @JvmName("rmouqqfteeyyprtd")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): KxScalingGroupArgs = KxScalingGroupArgs(
        availabilityZoneId = availabilityZoneId,
        environmentId = environmentId,
        hostType = hostType,
        name = name,
        tags = tags,
    )
}
