@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.finspace.kotlin

import com.pulumi.aws.finspace.KxUserArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS FinSpace Kx User.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.kms.Key("example", {
 *     description: "Example KMS Key",
 *     deletionWindowInDays: 7,
 * });
 * const exampleKxEnvironment = new aws.finspace.KxEnvironment("example", {
 *     name: "my-tf-kx-environment",
 *     kmsKeyId: example.arn,
 * });
 * const exampleRole = new aws.iam.Role("example", {
 *     name: "example-role",
 *     assumeRolePolicy: JSON.stringify({
 *         Version: "2012-10-17",
 *         Statement: [{
 *             Action: "sts:AssumeRole",
 *             Effect: "Allow",
 *             Sid: "",
 *             Principal: {
 *                 Service: "ec2.amazonaws.com",
 *             },
 *         }],
 *     }),
 * });
 * const exampleKxUser = new aws.finspace.KxUser("example", {
 *     name: "my-tf-kx-user",
 *     environmentId: exampleKxEnvironment.id,
 *     iamRole: exampleRole.arn,
 * });
 * ```
 * ```python
 * import pulumi
 * import json
 * import pulumi_aws as aws
 * example = aws.kms.Key("example",
 *     description="Example KMS Key",
 *     deletion_window_in_days=7)
 * example_kx_environment = aws.finspace.KxEnvironment("example",
 *     name="my-tf-kx-environment",
 *     kms_key_id=example.arn)
 * example_role = aws.iam.Role("example",
 *     name="example-role",
 *     assume_role_policy=json.dumps({
 *         "Version": "2012-10-17",
 *         "Statement": [{
 *             "Action": "sts:AssumeRole",
 *             "Effect": "Allow",
 *             "Sid": "",
 *             "Principal": {
 *                 "Service": "ec2.amazonaws.com",
 *             },
 *         }],
 *     }))
 * example_kx_user = aws.finspace.KxUser("example",
 *     name="my-tf-kx-user",
 *     environment_id=example_kx_environment.id,
 *     iam_role=example_role.arn)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using System.Text.Json;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Kms.Key("example", new()
 *     {
 *         Description = "Example KMS Key",
 *         DeletionWindowInDays = 7,
 *     });
 *     var exampleKxEnvironment = new Aws.FinSpace.KxEnvironment("example", new()
 *     {
 *         Name = "my-tf-kx-environment",
 *         KmsKeyId = example.Arn,
 *     });
 *     var exampleRole = new Aws.Iam.Role("example", new()
 *     {
 *         Name = "example-role",
 *         AssumeRolePolicy = JsonSerializer.Serialize(new Dictionary<string, object?>
 *         {
 *             ["Version"] = "2012-10-17",
 *             ["Statement"] = new[]
 *             {
 *                 new Dictionary<string, object?>
 *                 {
 *                     ["Action"] = "sts:AssumeRole",
 *                     ["Effect"] = "Allow",
 *                     ["Sid"] = "",
 *                     ["Principal"] = new Dictionary<string, object?>
 *                     {
 *                         ["Service"] = "ec2.amazonaws.com",
 *                     },
 *                 },
 *             },
 *         }),
 *     });
 *     var exampleKxUser = new Aws.FinSpace.KxUser("example", new()
 *     {
 *         Name = "my-tf-kx-user",
 *         EnvironmentId = exampleKxEnvironment.Id,
 *         IamRole = exampleRole.Arn,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"encoding/json"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/finspace"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/kms"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := kms.NewKey(ctx, "example", &kms.KeyArgs{
 * 			Description:          pulumi.String("Example KMS Key"),
 * 			DeletionWindowInDays: pulumi.Int(7),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleKxEnvironment, err := finspace.NewKxEnvironment(ctx, "example", &finspace.KxEnvironmentArgs{
 * 			Name:     pulumi.String("my-tf-kx-environment"),
 * 			KmsKeyId: example.Arn,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		tmpJSON0, err := json.Marshal(map[string]interface{}{
 * 			"Version": "2012-10-17",
 * 			"Statement": []map[string]interface{}{
 * 				map[string]interface{}{
 * 					"Action": "sts:AssumeRole",
 * 					"Effect": "Allow",
 * 					"Sid":    "",
 * 					"Principal": map[string]interface{}{
 * 						"Service": "ec2.amazonaws.com",
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		json0 := string(tmpJSON0)
 * 		exampleRole, err := iam.NewRole(ctx, "example", &iam.RoleArgs{
 * 			Name:             pulumi.String("example-role"),
 * 			AssumeRolePolicy: pulumi.String(json0),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = finspace.NewKxUser(ctx, "example", &finspace.KxUserArgs{
 * 			Name:          pulumi.String("my-tf-kx-user"),
 * 			EnvironmentId: exampleKxEnvironment.ID(),
 * 			IamRole:       exampleRole.Arn,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.kms.Key;
 * import com.pulumi.aws.kms.KeyArgs;
 * import com.pulumi.aws.finspace.KxEnvironment;
 * import com.pulumi.aws.finspace.KxEnvironmentArgs;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.finspace.KxUser;
 * import com.pulumi.aws.finspace.KxUserArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Key("example", KeyArgs.builder()
 *             .description("Example KMS Key")
 *             .deletionWindowInDays(7)
 *             .build());
 *         var exampleKxEnvironment = new KxEnvironment("exampleKxEnvironment", KxEnvironmentArgs.builder()
 *             .name("my-tf-kx-environment")
 *             .kmsKeyId(example.arn())
 *             .build());
 *         var exampleRole = new Role("exampleRole", RoleArgs.builder()
 *             .name("example-role")
 *             .assumeRolePolicy(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("Version", "2012-10-17"),
 *                     jsonProperty("Statement", jsonArray(jsonObject(
 *                         jsonProperty("Action", "sts:AssumeRole"),
 *                         jsonProperty("Effect", "Allow"),
 *                         jsonProperty("Sid", ""),
 *                         jsonProperty("Principal", jsonObject(
 *                             jsonProperty("Service", "ec2.amazonaws.com")
 *                         ))
 *                     )))
 *                 )))
 *             .build());
 *         var exampleKxUser = new KxUser("exampleKxUser", KxUserArgs.builder()
 *             .name("my-tf-kx-user")
 *             .environmentId(exampleKxEnvironment.id())
 *             .iamRole(exampleRole.arn())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:kms:Key
 *     properties:
 *       description: Example KMS Key
 *       deletionWindowInDays: 7
 *   exampleKxEnvironment:
 *     type: aws:finspace:KxEnvironment
 *     name: example
 *     properties:
 *       name: my-tf-kx-environment
 *       kmsKeyId: ${example.arn}
 *   exampleRole:
 *     type: aws:iam:Role
 *     name: example
 *     properties:
 *       name: example-role
 *       assumeRolePolicy:
 *         fn::toJSON:
 *           Version: 2012-10-17
 *           Statement:
 *             - Action: sts:AssumeRole
 *               Effect: Allow
 *               Sid:
 *               Principal:
 *                 Service: ec2.amazonaws.com
 *   exampleKxUser:
 *     type: aws:finspace:KxUser
 *     name: example
 *     properties:
 *       name: my-tf-kx-user
 *       environmentId: ${exampleKxEnvironment.id}
 *       iamRole: ${exampleRole.arn}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import an AWS FinSpace Kx User using the `id` (environment ID and user name, comma-delimited). For example:
 * ```sh
 * $ pulumi import aws:finspace/kxUser:KxUser example n3ceo7wqxoxcti5tujqwzs,my-tf-kx-user
 * ```
 * @property environmentId Unique identifier for the KX environment.
 * @property iamRole IAM role ARN to be associated with the user.
 * The following arguments are optional:
 * @property name A unique identifier for the user.
 * @property tags Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class KxUserArgs(
    public val environmentId: Output<String>? = null,
    public val iamRole: Output<String>? = null,
    public val name: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.finspace.KxUserArgs> {
    override fun toJava(): com.pulumi.aws.finspace.KxUserArgs =
        com.pulumi.aws.finspace.KxUserArgs.builder()
            .environmentId(environmentId?.applyValue({ args0 -> args0 }))
            .iamRole(iamRole?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [KxUserArgs].
 */
@PulumiTagMarker
public class KxUserArgsBuilder internal constructor() {
    private var environmentId: Output<String>? = null

    private var iamRole: Output<String>? = null

    private var name: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Unique identifier for the KX environment.
     */
    @JvmName("irsxqlexucxewqpe")
    public suspend fun environmentId(`value`: Output<String>) {
        this.environmentId = value
    }

    /**
     * @param value IAM role ARN to be associated with the user.
     * The following arguments are optional:
     */
    @JvmName("akasegpyxlbsjibu")
    public suspend fun iamRole(`value`: Output<String>) {
        this.iamRole = value
    }

    /**
     * @param value A unique identifier for the user.
     */
    @JvmName("lcyjocraeuqxbyye")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("rgbcbsssvyalqtij")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Unique identifier for the KX environment.
     */
    @JvmName("rocqmlolrimuklmn")
    public suspend fun environmentId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.environmentId = mapped
    }

    /**
     * @param value IAM role ARN to be associated with the user.
     * The following arguments are optional:
     */
    @JvmName("adoajyvcrbpxsmww")
    public suspend fun iamRole(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.iamRole = mapped
    }

    /**
     * @param value A unique identifier for the user.
     */
    @JvmName("pftenqhffevpenan")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ycjhlrgojldsdaxc")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("yrsetypwlvmibcme")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): KxUserArgs = KxUserArgs(
        environmentId = environmentId,
        iamRole = iamRole,
        name = name,
        tags = tags,
    )
}
