@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.finspace.kotlin

import com.pulumi.aws.finspace.kotlin.outputs.KxVolumeAttachedCluster
import com.pulumi.aws.finspace.kotlin.outputs.KxVolumeNas1Configuration
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.finspace.kotlin.outputs.KxVolumeAttachedCluster.Companion.toKotlin as kxVolumeAttachedClusterToKotlin
import com.pulumi.aws.finspace.kotlin.outputs.KxVolumeNas1Configuration.Companion.toKotlin as kxVolumeNas1ConfigurationToKotlin

/**
 * Builder for [KxVolume].
 */
@PulumiTagMarker
public class KxVolumeResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: KxVolumeArgs = KxVolumeArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend KxVolumeArgsBuilder.() -> Unit) {
        val builder = KxVolumeArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): KxVolume {
        val builtJavaResource = com.pulumi.aws.finspace.KxVolume(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return KxVolume(builtJavaResource)
    }
}

/**
 * Resource for managing an AWS FinSpace Kx Volume.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.finspace.KxVolume("example", {
 *     name: "my-tf-kx-volume",
 *     environmentId: exampleAwsFinspaceKxEnvironment.id,
 *     availabilityZones: "use1-az2",
 *     azMode: "SINGLE",
 *     type: "NAS_1",
 *     nas1Configurations: [{
 *         size: 1200,
 *         type: "SSD_250",
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.finspace.KxVolume("example",
 *     name="my-tf-kx-volume",
 *     environment_id=example_aws_finspace_kx_environment["id"],
 *     availability_zones="use1-az2",
 *     az_mode="SINGLE",
 *     type="NAS_1",
 *     nas1_configurations=[{
 *         "size": 1200,
 *         "type": "SSD_250",
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.FinSpace.KxVolume("example", new()
 *     {
 *         Name = "my-tf-kx-volume",
 *         EnvironmentId = exampleAwsFinspaceKxEnvironment.Id,
 *         AvailabilityZones = "use1-az2",
 *         AzMode = "SINGLE",
 *         Type = "NAS_1",
 *         Nas1Configurations = new[]
 *         {
 *             new Aws.FinSpace.Inputs.KxVolumeNas1ConfigurationArgs
 *             {
 *                 Size = 1200,
 *                 Type = "SSD_250",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/finspace"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := finspace.NewKxVolume(ctx, "example", &finspace.KxVolumeArgs{
 * 			Name:              pulumi.String("my-tf-kx-volume"),
 * 			EnvironmentId:     pulumi.Any(exampleAwsFinspaceKxEnvironment.Id),
 * 			AvailabilityZones: pulumi.StringArray("use1-az2"),
 * 			AzMode:            pulumi.String("SINGLE"),
 * 			Type:              pulumi.String("NAS_1"),
 * 			Nas1Configurations: finspace.KxVolumeNas1ConfigurationArray{
 * 				&finspace.KxVolumeNas1ConfigurationArgs{
 * 					Size: pulumi.Int(1200),
 * 					Type: pulumi.String("SSD_250"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.finspace.KxVolume;
 * import com.pulumi.aws.finspace.KxVolumeArgs;
 * import com.pulumi.aws.finspace.inputs.KxVolumeNas1ConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new KxVolume("example", KxVolumeArgs.builder()
 *             .name("my-tf-kx-volume")
 *             .environmentId(exampleAwsFinspaceKxEnvironment.id())
 *             .availabilityZones("use1-az2")
 *             .azMode("SINGLE")
 *             .type("NAS_1")
 *             .nas1Configurations(KxVolumeNas1ConfigurationArgs.builder()
 *                 .size(1200)
 *                 .type("SSD_250")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:finspace:KxVolume
 *     properties:
 *       name: my-tf-kx-volume
 *       environmentId: ${exampleAwsFinspaceKxEnvironment.id}
 *       availabilityZones: use1-az2
 *       azMode: SINGLE
 *       type: NAS_1
 *       nas1Configurations:
 *         - size: 1200
 *           type: SSD_250
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import an AWS FinSpace Kx Volume using the `id` (environment ID and volume name, comma-delimited). For example:
 * ```sh
 * $ pulumi import aws:finspace/kxVolume:KxVolume example n3ceo7wqxoxcti5tujqwzs,my-tf-kx-volume
 * ```
 */
public class KxVolume internal constructor(
    override val javaResource: com.pulumi.aws.finspace.KxVolume,
) : KotlinCustomResource(javaResource, KxVolumeMapper) {
    /**
     * Amazon Resource Name (ARN) identifier of the KX volume.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    public val attachedClusters: Output<List<KxVolumeAttachedCluster>>
        get() = javaResource.attachedClusters().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> kxVolumeAttachedClusterToKotlin(args0) })
            })
        })

    /**
     * The identifier of the AWS Availability Zone IDs.
     * The following arguments are optional:
     */
    public val availabilityZones: Output<List<String>>
        get() = javaResource.availabilityZones().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The number of availability zones you want to assign per volume. Currently, Finspace only support SINGLE for volumes.
     * * `SINGLE` - Assigns one availability zone per volume.
     */
    public val azMode: Output<String>
        get() = javaResource.azMode().applyValue({ args0 -> args0 })

    /**
     * The timestamp at which the volume was created in FinSpace. The value is determined as epoch time in milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.
     */
    public val createdTimestamp: Output<String>
        get() = javaResource.createdTimestamp().applyValue({ args0 -> args0 })

    /**
     * Description of the volume.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A unique identifier for the kdb environment, whose clusters can attach to the volume.
     */
    public val environmentId: Output<String>
        get() = javaResource.environmentId().applyValue({ args0 -> args0 })

    /**
     * Last timestamp at which the volume was updated in FinSpace. Value determined as epoch time in seconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000.
     */
    public val lastModifiedTimestamp: Output<String>
        get() = javaResource.lastModifiedTimestamp().applyValue({ args0 -> args0 })

    /**
     * Unique name for the volumr that you want to create.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Specifies the configuration for the Network attached storage (`NAS_1`) file system volume. This parameter is required when `volume_type` is `NAS_1`. See `nas1_configuration` Argument Reference below.
     */
    public val nas1Configurations: Output<List<KxVolumeNas1Configuration>>?
        get() = javaResource.nas1Configurations().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        kxVolumeNas1ConfigurationToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * The status of volume creation.
     * * `CREATING` – The volume creation is in progress.
     * * `CREATE_FAILED` – The volume creation has failed.
     * * `ACTIVE` – The volume is active.
     * * `UPDATING` – The volume is in the process of being updated.
     * * `UPDATE_FAILED` – The update action failed.
     * * `UPDATED` – The volume is successfully updated.
     * * `DELETING` – The volume is in the process of being deleted.
     * * `DELETE_FAILED` – The system failed to delete the volume.
     * * `DELETED` – The volume is successfully deleted.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * The error message when a failed state occurs.
     */
    public val statusReason: Output<String>
        get() = javaResource.statusReason().applyValue({ args0 -> args0 })

    /**
     * A list of key-value pairs to label the volume. You can add up to 50 tags to a volume
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * The type of file system volume. Currently, FinSpace only supports the `NAS_1` volume type. When you select the `NAS_1` volume type, you must also provide `nas1_configuration`.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object KxVolumeMapper : ResourceMapper<KxVolume> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.finspace.KxVolume::class == javaResource::class

    override fun map(javaResource: Resource): KxVolume = KxVolume(
        javaResource as
            com.pulumi.aws.finspace.KxVolume,
    )
}

/**
 * @see [KxVolume].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [KxVolume].
 */
public suspend fun kxVolume(name: String, block: suspend KxVolumeResourceBuilder.() -> Unit): KxVolume {
    val builder = KxVolumeResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [KxVolume].
 * @param name The _unique_ name of the resulting resource.
 */
public fun kxVolume(name: String): KxVolume {
    val builder = KxVolumeResourceBuilder()
    builder.name(name)
    return builder.build()
}
