@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.finspace.kotlin

import com.pulumi.aws.finspace.KxVolumeArgs.builder
import com.pulumi.aws.finspace.kotlin.inputs.KxVolumeNas1ConfigurationArgs
import com.pulumi.aws.finspace.kotlin.inputs.KxVolumeNas1ConfigurationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS FinSpace Kx Volume.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.finspace.KxVolume("example", {
 *     name: "my-tf-kx-volume",
 *     environmentId: exampleAwsFinspaceKxEnvironment.id,
 *     availabilityZones: "use1-az2",
 *     azMode: "SINGLE",
 *     type: "NAS_1",
 *     nas1Configurations: [{
 *         size: 1200,
 *         type: "SSD_250",
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.finspace.KxVolume("example",
 *     name="my-tf-kx-volume",
 *     environment_id=example_aws_finspace_kx_environment["id"],
 *     availability_zones="use1-az2",
 *     az_mode="SINGLE",
 *     type="NAS_1",
 *     nas1_configurations=[{
 *         "size": 1200,
 *         "type": "SSD_250",
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.FinSpace.KxVolume("example", new()
 *     {
 *         Name = "my-tf-kx-volume",
 *         EnvironmentId = exampleAwsFinspaceKxEnvironment.Id,
 *         AvailabilityZones = "use1-az2",
 *         AzMode = "SINGLE",
 *         Type = "NAS_1",
 *         Nas1Configurations = new[]
 *         {
 *             new Aws.FinSpace.Inputs.KxVolumeNas1ConfigurationArgs
 *             {
 *                 Size = 1200,
 *                 Type = "SSD_250",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/finspace"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := finspace.NewKxVolume(ctx, "example", &finspace.KxVolumeArgs{
 * 			Name:              pulumi.String("my-tf-kx-volume"),
 * 			EnvironmentId:     pulumi.Any(exampleAwsFinspaceKxEnvironment.Id),
 * 			AvailabilityZones: pulumi.StringArray("use1-az2"),
 * 			AzMode:            pulumi.String("SINGLE"),
 * 			Type:              pulumi.String("NAS_1"),
 * 			Nas1Configurations: finspace.KxVolumeNas1ConfigurationArray{
 * 				&finspace.KxVolumeNas1ConfigurationArgs{
 * 					Size: pulumi.Int(1200),
 * 					Type: pulumi.String("SSD_250"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.finspace.KxVolume;
 * import com.pulumi.aws.finspace.KxVolumeArgs;
 * import com.pulumi.aws.finspace.inputs.KxVolumeNas1ConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new KxVolume("example", KxVolumeArgs.builder()
 *             .name("my-tf-kx-volume")
 *             .environmentId(exampleAwsFinspaceKxEnvironment.id())
 *             .availabilityZones("use1-az2")
 *             .azMode("SINGLE")
 *             .type("NAS_1")
 *             .nas1Configurations(KxVolumeNas1ConfigurationArgs.builder()
 *                 .size(1200)
 *                 .type("SSD_250")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:finspace:KxVolume
 *     properties:
 *       name: my-tf-kx-volume
 *       environmentId: ${exampleAwsFinspaceKxEnvironment.id}
 *       availabilityZones: use1-az2
 *       azMode: SINGLE
 *       type: NAS_1
 *       nas1Configurations:
 *         - size: 1200
 *           type: SSD_250
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import an AWS FinSpace Kx Volume using the `id` (environment ID and volume name, comma-delimited). For example:
 * ```sh
 * $ pulumi import aws:finspace/kxVolume:KxVolume example n3ceo7wqxoxcti5tujqwzs,my-tf-kx-volume
 * ```
 * @property availabilityZones The identifier of the AWS Availability Zone IDs.
 * The following arguments are optional:
 * @property azMode The number of availability zones you want to assign per volume. Currently, Finspace only support SINGLE for volumes.
 * * `SINGLE` - Assigns one availability zone per volume.
 * @property description Description of the volume.
 * @property environmentId A unique identifier for the kdb environment, whose clusters can attach to the volume.
 * @property name Unique name for the volumr that you want to create.
 * @property nas1Configurations Specifies the configuration for the Network attached storage (`NAS_1`) file system volume. This parameter is required when `volume_type` is `NAS_1`. See `nas1_configuration` Argument Reference below.
 * @property tags A list of key-value pairs to label the volume. You can add up to 50 tags to a volume
 * @property type The type of file system volume. Currently, FinSpace only supports the `NAS_1` volume type. When you select the `NAS_1` volume type, you must also provide `nas1_configuration`.
 */
public data class KxVolumeArgs(
    public val availabilityZones: Output<List<String>>? = null,
    public val azMode: Output<String>? = null,
    public val description: Output<String>? = null,
    public val environmentId: Output<String>? = null,
    public val name: Output<String>? = null,
    public val nas1Configurations: Output<List<KxVolumeNas1ConfigurationArgs>>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val type: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.finspace.KxVolumeArgs> {
    override fun toJava(): com.pulumi.aws.finspace.KxVolumeArgs =
        com.pulumi.aws.finspace.KxVolumeArgs.builder()
            .availabilityZones(availabilityZones?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .azMode(azMode?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .environmentId(environmentId?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .nas1Configurations(
                nas1Configurations?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .type(type?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [KxVolumeArgs].
 */
@PulumiTagMarker
public class KxVolumeArgsBuilder internal constructor() {
    private var availabilityZones: Output<List<String>>? = null

    private var azMode: Output<String>? = null

    private var description: Output<String>? = null

    private var environmentId: Output<String>? = null

    private var name: Output<String>? = null

    private var nas1Configurations: Output<List<KxVolumeNas1ConfigurationArgs>>? = null

    private var tags: Output<Map<String, String>>? = null

    private var type: Output<String>? = null

    /**
     * @param value The identifier of the AWS Availability Zone IDs.
     * The following arguments are optional:
     */
    @JvmName("pknxejqlyvsoapib")
    public suspend fun availabilityZones(`value`: Output<List<String>>) {
        this.availabilityZones = value
    }

    @JvmName("ccjhqsufwdcoqupo")
    public suspend fun availabilityZones(vararg values: Output<String>) {
        this.availabilityZones = Output.all(values.asList())
    }

    /**
     * @param values The identifier of the AWS Availability Zone IDs.
     * The following arguments are optional:
     */
    @JvmName("jurxwdamlkrywcnj")
    public suspend fun availabilityZones(values: List<Output<String>>) {
        this.availabilityZones = Output.all(values)
    }

    /**
     * @param value The number of availability zones you want to assign per volume. Currently, Finspace only support SINGLE for volumes.
     * * `SINGLE` - Assigns one availability zone per volume.
     */
    @JvmName("wynnggxuqhqpaojf")
    public suspend fun azMode(`value`: Output<String>) {
        this.azMode = value
    }

    /**
     * @param value Description of the volume.
     */
    @JvmName("qbsxxoxnclcsuroo")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value A unique identifier for the kdb environment, whose clusters can attach to the volume.
     */
    @JvmName("rqbecmtihaylqjhv")
    public suspend fun environmentId(`value`: Output<String>) {
        this.environmentId = value
    }

    /**
     * @param value Unique name for the volumr that you want to create.
     */
    @JvmName("eibrekcomccohdaw")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Specifies the configuration for the Network attached storage (`NAS_1`) file system volume. This parameter is required when `volume_type` is `NAS_1`. See `nas1_configuration` Argument Reference below.
     */
    @JvmName("ceextocxibfnyugv")
    public suspend fun nas1Configurations(`value`: Output<List<KxVolumeNas1ConfigurationArgs>>) {
        this.nas1Configurations = value
    }

    @JvmName("dxvohbvsxtlphgsc")
    public suspend fun nas1Configurations(vararg values: Output<KxVolumeNas1ConfigurationArgs>) {
        this.nas1Configurations = Output.all(values.asList())
    }

    /**
     * @param values Specifies the configuration for the Network attached storage (`NAS_1`) file system volume. This parameter is required when `volume_type` is `NAS_1`. See `nas1_configuration` Argument Reference below.
     */
    @JvmName("vbocayudnbttfxce")
    public suspend fun nas1Configurations(values: List<Output<KxVolumeNas1ConfigurationArgs>>) {
        this.nas1Configurations = Output.all(values)
    }

    /**
     * @param value A list of key-value pairs to label the volume. You can add up to 50 tags to a volume
     */
    @JvmName("vdxfvcnblyxmbntg")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The type of file system volume. Currently, FinSpace only supports the `NAS_1` volume type. When you select the `NAS_1` volume type, you must also provide `nas1_configuration`.
     */
    @JvmName("utfdwmshrggpqnvb")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The identifier of the AWS Availability Zone IDs.
     * The following arguments are optional:
     */
    @JvmName("ghryfcdcskfjneat")
    public suspend fun availabilityZones(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.availabilityZones = mapped
    }

    /**
     * @param values The identifier of the AWS Availability Zone IDs.
     * The following arguments are optional:
     */
    @JvmName("cugffimkkjaggywk")
    public suspend fun availabilityZones(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.availabilityZones = mapped
    }

    /**
     * @param value The number of availability zones you want to assign per volume. Currently, Finspace only support SINGLE for volumes.
     * * `SINGLE` - Assigns one availability zone per volume.
     */
    @JvmName("rfljscbdkhhmnkis")
    public suspend fun azMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.azMode = mapped
    }

    /**
     * @param value Description of the volume.
     */
    @JvmName("cfyjaopwcyunppsl")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value A unique identifier for the kdb environment, whose clusters can attach to the volume.
     */
    @JvmName("fdxvsnjebxrsasdj")
    public suspend fun environmentId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.environmentId = mapped
    }

    /**
     * @param value Unique name for the volumr that you want to create.
     */
    @JvmName("ojjpphvevsiimcbi")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Specifies the configuration for the Network attached storage (`NAS_1`) file system volume. This parameter is required when `volume_type` is `NAS_1`. See `nas1_configuration` Argument Reference below.
     */
    @JvmName("ramxvbadbgyodncg")
    public suspend fun nas1Configurations(`value`: List<KxVolumeNas1ConfigurationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nas1Configurations = mapped
    }

    /**
     * @param argument Specifies the configuration for the Network attached storage (`NAS_1`) file system volume. This parameter is required when `volume_type` is `NAS_1`. See `nas1_configuration` Argument Reference below.
     */
    @JvmName("ashoawgasporfxiu")
    public suspend fun nas1Configurations(argument: List<suspend KxVolumeNas1ConfigurationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            KxVolumeNas1ConfigurationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.nas1Configurations = mapped
    }

    /**
     * @param argument Specifies the configuration for the Network attached storage (`NAS_1`) file system volume. This parameter is required when `volume_type` is `NAS_1`. See `nas1_configuration` Argument Reference below.
     */
    @JvmName("feltevivcygrpvgr")
    public suspend fun nas1Configurations(vararg argument: suspend KxVolumeNas1ConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            KxVolumeNas1ConfigurationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.nas1Configurations = mapped
    }

    /**
     * @param argument Specifies the configuration for the Network attached storage (`NAS_1`) file system volume. This parameter is required when `volume_type` is `NAS_1`. See `nas1_configuration` Argument Reference below.
     */
    @JvmName("bowchqgjralpqmkb")
    public suspend fun nas1Configurations(argument: suspend KxVolumeNas1ConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            KxVolumeNas1ConfigurationArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.nas1Configurations = mapped
    }

    /**
     * @param values Specifies the configuration for the Network attached storage (`NAS_1`) file system volume. This parameter is required when `volume_type` is `NAS_1`. See `nas1_configuration` Argument Reference below.
     */
    @JvmName("tkbakvystophkkgs")
    public suspend fun nas1Configurations(vararg values: KxVolumeNas1ConfigurationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.nas1Configurations = mapped
    }

    /**
     * @param value A list of key-value pairs to label the volume. You can add up to 50 tags to a volume
     */
    @JvmName("gtbudwkubgdvjfha")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A list of key-value pairs to label the volume. You can add up to 50 tags to a volume
     */
    @JvmName("hbhhahmijdkxwsuk")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The type of file system volume. Currently, FinSpace only supports the `NAS_1` volume type. When you select the `NAS_1` volume type, you must also provide `nas1_configuration`.
     */
    @JvmName("kjlorjcosaolemhg")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): KxVolumeArgs = KxVolumeArgs(
        availabilityZones = availabilityZones,
        azMode = azMode,
        description = description,
        environmentId = environmentId,
        name = name,
        nas1Configurations = nas1Configurations,
        tags = tags,
        type = type,
    )
}
