@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.finspace.kotlin.inputs

import com.pulumi.aws.finspace.inputs.KxClusterAutoScalingConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property autoScalingMetric Metric your cluster will track in order to scale in and out. For example, CPU_UTILIZATION_PERCENTAGE is the average CPU usage across all nodes in a cluster.
 * @property maxNodeCount Highest number of nodes to scale. Cannot be greater than 5
 * @property metricTarget Desired value of chosen `auto_scaling_metric`. When metric drops below this value, cluster will scale in. When metric goes above this value, cluster will scale out. Can be set between 0 and 100 percent.
 * @property minNodeCount Lowest number of nodes to scale. Must be at least 1 and less than the `max_node_count`. If nodes in cluster belong to multiple availability zones, then `min_node_count` must be at least 3.
 * @property scaleInCooldownSeconds Duration in seconds that FinSpace will wait after a scale in event before initiating another scaling event.
 * @property scaleOutCooldownSeconds Duration in seconds that FinSpace will wait after a scale out event before initiating another scaling event.
 */
public data class KxClusterAutoScalingConfigurationArgs(
    public val autoScalingMetric: Output<String>,
    public val maxNodeCount: Output<Int>,
    public val metricTarget: Output<Double>,
    public val minNodeCount: Output<Int>,
    public val scaleInCooldownSeconds: Output<Double>,
    public val scaleOutCooldownSeconds: Output<Double>,
) : ConvertibleToJava<com.pulumi.aws.finspace.inputs.KxClusterAutoScalingConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.finspace.inputs.KxClusterAutoScalingConfigurationArgs =
        com.pulumi.aws.finspace.inputs.KxClusterAutoScalingConfigurationArgs.builder()
            .autoScalingMetric(autoScalingMetric.applyValue({ args0 -> args0 }))
            .maxNodeCount(maxNodeCount.applyValue({ args0 -> args0 }))
            .metricTarget(metricTarget.applyValue({ args0 -> args0 }))
            .minNodeCount(minNodeCount.applyValue({ args0 -> args0 }))
            .scaleInCooldownSeconds(scaleInCooldownSeconds.applyValue({ args0 -> args0 }))
            .scaleOutCooldownSeconds(scaleOutCooldownSeconds.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [KxClusterAutoScalingConfigurationArgs].
 */
@PulumiTagMarker
public class KxClusterAutoScalingConfigurationArgsBuilder internal constructor() {
    private var autoScalingMetric: Output<String>? = null

    private var maxNodeCount: Output<Int>? = null

    private var metricTarget: Output<Double>? = null

    private var minNodeCount: Output<Int>? = null

    private var scaleInCooldownSeconds: Output<Double>? = null

    private var scaleOutCooldownSeconds: Output<Double>? = null

    /**
     * @param value Metric your cluster will track in order to scale in and out. For example, CPU_UTILIZATION_PERCENTAGE is the average CPU usage across all nodes in a cluster.
     */
    @JvmName("vkctygeysdyxjjju")
    public suspend fun autoScalingMetric(`value`: Output<String>) {
        this.autoScalingMetric = value
    }

    /**
     * @param value Highest number of nodes to scale. Cannot be greater than 5
     */
    @JvmName("nhjowlrgmcrbvdvo")
    public suspend fun maxNodeCount(`value`: Output<Int>) {
        this.maxNodeCount = value
    }

    /**
     * @param value Desired value of chosen `auto_scaling_metric`. When metric drops below this value, cluster will scale in. When metric goes above this value, cluster will scale out. Can be set between 0 and 100 percent.
     */
    @JvmName("ihbapbgixsyfmtmt")
    public suspend fun metricTarget(`value`: Output<Double>) {
        this.metricTarget = value
    }

    /**
     * @param value Lowest number of nodes to scale. Must be at least 1 and less than the `max_node_count`. If nodes in cluster belong to multiple availability zones, then `min_node_count` must be at least 3.
     */
    @JvmName("sbaaiancecucpoqh")
    public suspend fun minNodeCount(`value`: Output<Int>) {
        this.minNodeCount = value
    }

    /**
     * @param value Duration in seconds that FinSpace will wait after a scale in event before initiating another scaling event.
     */
    @JvmName("rqehwujjwqvojweu")
    public suspend fun scaleInCooldownSeconds(`value`: Output<Double>) {
        this.scaleInCooldownSeconds = value
    }

    /**
     * @param value Duration in seconds that FinSpace will wait after a scale out event before initiating another scaling event.
     */
    @JvmName("txvawevypwqyjbqq")
    public suspend fun scaleOutCooldownSeconds(`value`: Output<Double>) {
        this.scaleOutCooldownSeconds = value
    }

    /**
     * @param value Metric your cluster will track in order to scale in and out. For example, CPU_UTILIZATION_PERCENTAGE is the average CPU usage across all nodes in a cluster.
     */
    @JvmName("rvgmsjtecypjmuah")
    public suspend fun autoScalingMetric(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.autoScalingMetric = mapped
    }

    /**
     * @param value Highest number of nodes to scale. Cannot be greater than 5
     */
    @JvmName("tggwyyvnibjhwsif")
    public suspend fun maxNodeCount(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.maxNodeCount = mapped
    }

    /**
     * @param value Desired value of chosen `auto_scaling_metric`. When metric drops below this value, cluster will scale in. When metric goes above this value, cluster will scale out. Can be set between 0 and 100 percent.
     */
    @JvmName("mbipaokyifexosqy")
    public suspend fun metricTarget(`value`: Double) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.metricTarget = mapped
    }

    /**
     * @param value Lowest number of nodes to scale. Must be at least 1 and less than the `max_node_count`. If nodes in cluster belong to multiple availability zones, then `min_node_count` must be at least 3.
     */
    @JvmName("qyptwhadhmapnumy")
    public suspend fun minNodeCount(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.minNodeCount = mapped
    }

    /**
     * @param value Duration in seconds that FinSpace will wait after a scale in event before initiating another scaling event.
     */
    @JvmName("qdbhcvbrcgjqellj")
    public suspend fun scaleInCooldownSeconds(`value`: Double) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.scaleInCooldownSeconds = mapped
    }

    /**
     * @param value Duration in seconds that FinSpace will wait after a scale out event before initiating another scaling event.
     */
    @JvmName("qjuwgogqpjxkuvia")
    public suspend fun scaleOutCooldownSeconds(`value`: Double) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.scaleOutCooldownSeconds = mapped
    }

    internal fun build(): KxClusterAutoScalingConfigurationArgs =
        KxClusterAutoScalingConfigurationArgs(
            autoScalingMetric = autoScalingMetric ?: throw PulumiNullFieldException("autoScalingMetric"),
            maxNodeCount = maxNodeCount ?: throw PulumiNullFieldException("maxNodeCount"),
            metricTarget = metricTarget ?: throw PulumiNullFieldException("metricTarget"),
            minNodeCount = minNodeCount ?: throw PulumiNullFieldException("minNodeCount"),
            scaleInCooldownSeconds = scaleInCooldownSeconds ?: throw
                PulumiNullFieldException("scaleInCooldownSeconds"),
            scaleOutCooldownSeconds = scaleOutCooldownSeconds ?: throw
                PulumiNullFieldException("scaleOutCooldownSeconds"),
        )
}
