@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.finspace.kotlin.inputs

import com.pulumi.aws.finspace.inputs.KxClusterCapacityConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property nodeCount Number of instances running in a cluster. Must be at least 1 and at most 5.
 * @property nodeType Determines the hardware of the host computer used for your cluster instance. Each node type offers different memory and storage capabilities. Choose a node type based on the requirements of the application or software that you plan to run on your instance.
 * You can only specify one of the following values:
 * * kx.s.large – The node type with a configuration of 12 GiB memory and 2 vCPUs.
 * * kx.s.xlarge – The node type with a configuration of 27 GiB memory and 4 vCPUs.
 * * kx.s.2xlarge – The node type with a configuration of 54 GiB memory and 8 vCPUs.
 * * kx.s.4xlarge – The node type with a configuration of 108 GiB memory and 16 vCPUs.
 * * kx.s.8xlarge – The node type with a configuration of 216 GiB memory and 32 vCPUs.
 * * kx.s.16xlarge – The node type with a configuration of 432 GiB memory and 64 vCPUs.
 * * kx.s.32xlarge – The node type with a configuration of 864 GiB memory and 128 vCPUs.
 */
public data class KxClusterCapacityConfigurationArgs(
    public val nodeCount: Output<Int>,
    public val nodeType: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.finspace.inputs.KxClusterCapacityConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.finspace.inputs.KxClusterCapacityConfigurationArgs =
        com.pulumi.aws.finspace.inputs.KxClusterCapacityConfigurationArgs.builder()
            .nodeCount(nodeCount.applyValue({ args0 -> args0 }))
            .nodeType(nodeType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [KxClusterCapacityConfigurationArgs].
 */
@PulumiTagMarker
public class KxClusterCapacityConfigurationArgsBuilder internal constructor() {
    private var nodeCount: Output<Int>? = null

    private var nodeType: Output<String>? = null

    /**
     * @param value Number of instances running in a cluster. Must be at least 1 and at most 5.
     */
    @JvmName("oboylxhlvgnwkgek")
    public suspend fun nodeCount(`value`: Output<Int>) {
        this.nodeCount = value
    }

    /**
     * @param value Determines the hardware of the host computer used for your cluster instance. Each node type offers different memory and storage capabilities. Choose a node type based on the requirements of the application or software that you plan to run on your instance.
     * You can only specify one of the following values:
     * * kx.s.large – The node type with a configuration of 12 GiB memory and 2 vCPUs.
     * * kx.s.xlarge – The node type with a configuration of 27 GiB memory and 4 vCPUs.
     * * kx.s.2xlarge – The node type with a configuration of 54 GiB memory and 8 vCPUs.
     * * kx.s.4xlarge – The node type with a configuration of 108 GiB memory and 16 vCPUs.
     * * kx.s.8xlarge – The node type with a configuration of 216 GiB memory and 32 vCPUs.
     * * kx.s.16xlarge – The node type with a configuration of 432 GiB memory and 64 vCPUs.
     * * kx.s.32xlarge – The node type with a configuration of 864 GiB memory and 128 vCPUs.
     */
    @JvmName("luqanpmidqeblpws")
    public suspend fun nodeType(`value`: Output<String>) {
        this.nodeType = value
    }

    /**
     * @param value Number of instances running in a cluster. Must be at least 1 and at most 5.
     */
    @JvmName("ietytxgabgwywdpx")
    public suspend fun nodeCount(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.nodeCount = mapped
    }

    /**
     * @param value Determines the hardware of the host computer used for your cluster instance. Each node type offers different memory and storage capabilities. Choose a node type based on the requirements of the application or software that you plan to run on your instance.
     * You can only specify one of the following values:
     * * kx.s.large – The node type with a configuration of 12 GiB memory and 2 vCPUs.
     * * kx.s.xlarge – The node type with a configuration of 27 GiB memory and 4 vCPUs.
     * * kx.s.2xlarge – The node type with a configuration of 54 GiB memory and 8 vCPUs.
     * * kx.s.4xlarge – The node type with a configuration of 108 GiB memory and 16 vCPUs.
     * * kx.s.8xlarge – The node type with a configuration of 216 GiB memory and 32 vCPUs.
     * * kx.s.16xlarge – The node type with a configuration of 432 GiB memory and 64 vCPUs.
     * * kx.s.32xlarge – The node type with a configuration of 864 GiB memory and 128 vCPUs.
     */
    @JvmName("pjmcjgcbckauadjc")
    public suspend fun nodeType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.nodeType = mapped
    }

    internal fun build(): KxClusterCapacityConfigurationArgs = KxClusterCapacityConfigurationArgs(
        nodeCount = nodeCount ?: throw PulumiNullFieldException("nodeCount"),
        nodeType = nodeType ?: throw PulumiNullFieldException("nodeType"),
    )
}
