@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.finspace.kotlin.inputs

import com.pulumi.aws.finspace.inputs.KxClusterDatabaseArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property cacheConfigurations Configuration details for the disk cache to increase performance reading from a KX database mounted to the cluster. See cache_configurations.
 * @property changesetId A unique identifier of the changeset that is associated with the cluster.
 * @property databaseName Name of the KX database.
 * @property dataviewName The name of the dataview to be used for caching historical data on disk. You cannot update to a different dataview name once a cluster is created. Use `lifecycle` `ignore_changes` for database to prevent any undesirable behaviors.
 */
public data class KxClusterDatabaseArgs(
    public val cacheConfigurations: Output<List<KxClusterDatabaseCacheConfigurationArgs>>? = null,
    public val changesetId: Output<String>? = null,
    public val databaseName: Output<String>,
    public val dataviewName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.finspace.inputs.KxClusterDatabaseArgs> {
    override fun toJava(): com.pulumi.aws.finspace.inputs.KxClusterDatabaseArgs =
        com.pulumi.aws.finspace.inputs.KxClusterDatabaseArgs.builder()
            .cacheConfigurations(
                cacheConfigurations?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .changesetId(changesetId?.applyValue({ args0 -> args0 }))
            .databaseName(databaseName.applyValue({ args0 -> args0 }))
            .dataviewName(dataviewName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [KxClusterDatabaseArgs].
 */
@PulumiTagMarker
public class KxClusterDatabaseArgsBuilder internal constructor() {
    private var cacheConfigurations: Output<List<KxClusterDatabaseCacheConfigurationArgs>>? = null

    private var changesetId: Output<String>? = null

    private var databaseName: Output<String>? = null

    private var dataviewName: Output<String>? = null

    /**
     * @param value Configuration details for the disk cache to increase performance reading from a KX database mounted to the cluster. See cache_configurations.
     */
    @JvmName("hmqgtpkewdbnbitv")
    public suspend fun cacheConfigurations(`value`: Output<List<KxClusterDatabaseCacheConfigurationArgs>>) {
        this.cacheConfigurations = value
    }

    @JvmName("hnycpwhvbrratcgw")
    public suspend fun cacheConfigurations(vararg values: Output<KxClusterDatabaseCacheConfigurationArgs>) {
        this.cacheConfigurations = Output.all(values.asList())
    }

    /**
     * @param values Configuration details for the disk cache to increase performance reading from a KX database mounted to the cluster. See cache_configurations.
     */
    @JvmName("oqrxkngmjmsjrhbf")
    public suspend fun cacheConfigurations(values: List<Output<KxClusterDatabaseCacheConfigurationArgs>>) {
        this.cacheConfigurations = Output.all(values)
    }

    /**
     * @param value A unique identifier of the changeset that is associated with the cluster.
     */
    @JvmName("hpxnquwbmrpurwhp")
    public suspend fun changesetId(`value`: Output<String>) {
        this.changesetId = value
    }

    /**
     * @param value Name of the KX database.
     */
    @JvmName("fakqsptouepyjahy")
    public suspend fun databaseName(`value`: Output<String>) {
        this.databaseName = value
    }

    /**
     * @param value The name of the dataview to be used for caching historical data on disk. You cannot update to a different dataview name once a cluster is created. Use `lifecycle` `ignore_changes` for database to prevent any undesirable behaviors.
     */
    @JvmName("wplpuuqyioibhqlp")
    public suspend fun dataviewName(`value`: Output<String>) {
        this.dataviewName = value
    }

    /**
     * @param value Configuration details for the disk cache to increase performance reading from a KX database mounted to the cluster. See cache_configurations.
     */
    @JvmName("tplthwbsmldpijbs")
    public suspend fun cacheConfigurations(`value`: List<KxClusterDatabaseCacheConfigurationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cacheConfigurations = mapped
    }

    /**
     * @param argument Configuration details for the disk cache to increase performance reading from a KX database mounted to the cluster. See cache_configurations.
     */
    @JvmName("ucitstvslhwaqgjr")
    public suspend fun cacheConfigurations(argument: List<suspend KxClusterDatabaseCacheConfigurationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            KxClusterDatabaseCacheConfigurationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.cacheConfigurations = mapped
    }

    /**
     * @param argument Configuration details for the disk cache to increase performance reading from a KX database mounted to the cluster. See cache_configurations.
     */
    @JvmName("ihieuqgwadesujru")
    public suspend fun cacheConfigurations(vararg argument: suspend KxClusterDatabaseCacheConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            KxClusterDatabaseCacheConfigurationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.cacheConfigurations = mapped
    }

    /**
     * @param argument Configuration details for the disk cache to increase performance reading from a KX database mounted to the cluster. See cache_configurations.
     */
    @JvmName("ttjkerxvbityngcl")
    public suspend fun cacheConfigurations(argument: suspend KxClusterDatabaseCacheConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            KxClusterDatabaseCacheConfigurationArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.cacheConfigurations = mapped
    }

    /**
     * @param values Configuration details for the disk cache to increase performance reading from a KX database mounted to the cluster. See cache_configurations.
     */
    @JvmName("vjcskwjhdbegnlyy")
    public suspend fun cacheConfigurations(vararg values: KxClusterDatabaseCacheConfigurationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.cacheConfigurations = mapped
    }

    /**
     * @param value A unique identifier of the changeset that is associated with the cluster.
     */
    @JvmName("aygqmlssdhiedjfl")
    public suspend fun changesetId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.changesetId = mapped
    }

    /**
     * @param value Name of the KX database.
     */
    @JvmName("uikqqvymswjmvdcq")
    public suspend fun databaseName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.databaseName = mapped
    }

    /**
     * @param value The name of the dataview to be used for caching historical data on disk. You cannot update to a different dataview name once a cluster is created. Use `lifecycle` `ignore_changes` for database to prevent any undesirable behaviors.
     */
    @JvmName("dcayuiojbtwqyiwq")
    public suspend fun dataviewName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataviewName = mapped
    }

    internal fun build(): KxClusterDatabaseArgs = KxClusterDatabaseArgs(
        cacheConfigurations = cacheConfigurations,
        changesetId = changesetId,
        databaseName = databaseName ?: throw PulumiNullFieldException("databaseName"),
        dataviewName = dataviewName,
    )
}
