@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.finspace.kotlin.inputs

import com.pulumi.aws.finspace.inputs.KxClusterDatabaseCacheConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property cacheType Type of disk cache.
 * @property dbPaths Paths within the database to cache.
 */
public data class KxClusterDatabaseCacheConfigurationArgs(
    public val cacheType: Output<String>,
    public val dbPaths: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.finspace.inputs.KxClusterDatabaseCacheConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.finspace.inputs.KxClusterDatabaseCacheConfigurationArgs =
        com.pulumi.aws.finspace.inputs.KxClusterDatabaseCacheConfigurationArgs.builder()
            .cacheType(cacheType.applyValue({ args0 -> args0 }))
            .dbPaths(dbPaths?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [KxClusterDatabaseCacheConfigurationArgs].
 */
@PulumiTagMarker
public class KxClusterDatabaseCacheConfigurationArgsBuilder internal constructor() {
    private var cacheType: Output<String>? = null

    private var dbPaths: Output<List<String>>? = null

    /**
     * @param value Type of disk cache.
     */
    @JvmName("wpdhkdmbfiinyxpi")
    public suspend fun cacheType(`value`: Output<String>) {
        this.cacheType = value
    }

    /**
     * @param value Paths within the database to cache.
     */
    @JvmName("gpvloelvvnfcxqcr")
    public suspend fun dbPaths(`value`: Output<List<String>>) {
        this.dbPaths = value
    }

    @JvmName("yrfpgcaesamjahhx")
    public suspend fun dbPaths(vararg values: Output<String>) {
        this.dbPaths = Output.all(values.asList())
    }

    /**
     * @param values Paths within the database to cache.
     */
    @JvmName("yfxlfrhgvdxyilgh")
    public suspend fun dbPaths(values: List<Output<String>>) {
        this.dbPaths = Output.all(values)
    }

    /**
     * @param value Type of disk cache.
     */
    @JvmName("higawqogngkffkji")
    public suspend fun cacheType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.cacheType = mapped
    }

    /**
     * @param value Paths within the database to cache.
     */
    @JvmName("uvlktmqnyvmekwoq")
    public suspend fun dbPaths(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dbPaths = mapped
    }

    /**
     * @param values Paths within the database to cache.
     */
    @JvmName("revbytxbvjunwhoe")
    public suspend fun dbPaths(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dbPaths = mapped
    }

    internal fun build(): KxClusterDatabaseCacheConfigurationArgs =
        KxClusterDatabaseCacheConfigurationArgs(
            cacheType = cacheType ?: throw PulumiNullFieldException("cacheType"),
            dbPaths = dbPaths,
        )
}
