@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.finspace.kotlin.inputs

import com.pulumi.aws.finspace.inputs.KxClusterScalingGroupConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property cpu The number of vCPUs that you want to reserve for each node of this kdb cluster on the scaling group host.
 * @property memoryLimit An optional hard limit on the amount of memory a kdb cluster can use.
 * @property memoryReservation A reservation of the minimum amount of memory that should be available on the scaling group for a kdb cluster to be successfully placed in a scaling group.
 * @property nodeCount The number of kdb cluster nodes.
 * @property scalingGroupName A unique identifier for the kdb scaling group.
 */
public data class KxClusterScalingGroupConfigurationArgs(
    public val cpu: Output<Double>? = null,
    public val memoryLimit: Output<Int>? = null,
    public val memoryReservation: Output<Int>,
    public val nodeCount: Output<Int>,
    public val scalingGroupName: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.finspace.inputs.KxClusterScalingGroupConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.finspace.inputs.KxClusterScalingGroupConfigurationArgs =
        com.pulumi.aws.finspace.inputs.KxClusterScalingGroupConfigurationArgs.builder()
            .cpu(cpu?.applyValue({ args0 -> args0 }))
            .memoryLimit(memoryLimit?.applyValue({ args0 -> args0 }))
            .memoryReservation(memoryReservation.applyValue({ args0 -> args0 }))
            .nodeCount(nodeCount.applyValue({ args0 -> args0 }))
            .scalingGroupName(scalingGroupName.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [KxClusterScalingGroupConfigurationArgs].
 */
@PulumiTagMarker
public class KxClusterScalingGroupConfigurationArgsBuilder internal constructor() {
    private var cpu: Output<Double>? = null

    private var memoryLimit: Output<Int>? = null

    private var memoryReservation: Output<Int>? = null

    private var nodeCount: Output<Int>? = null

    private var scalingGroupName: Output<String>? = null

    /**
     * @param value The number of vCPUs that you want to reserve for each node of this kdb cluster on the scaling group host.
     */
    @JvmName("lpmwepfjjfthuvln")
    public suspend fun cpu(`value`: Output<Double>) {
        this.cpu = value
    }

    /**
     * @param value An optional hard limit on the amount of memory a kdb cluster can use.
     */
    @JvmName("wbpisdbxdemjrwae")
    public suspend fun memoryLimit(`value`: Output<Int>) {
        this.memoryLimit = value
    }

    /**
     * @param value A reservation of the minimum amount of memory that should be available on the scaling group for a kdb cluster to be successfully placed in a scaling group.
     */
    @JvmName("lqsamucukrpqyatx")
    public suspend fun memoryReservation(`value`: Output<Int>) {
        this.memoryReservation = value
    }

    /**
     * @param value The number of kdb cluster nodes.
     */
    @JvmName("obfnpvbylywfytpg")
    public suspend fun nodeCount(`value`: Output<Int>) {
        this.nodeCount = value
    }

    /**
     * @param value A unique identifier for the kdb scaling group.
     */
    @JvmName("iqsbrbuuwuuayito")
    public suspend fun scalingGroupName(`value`: Output<String>) {
        this.scalingGroupName = value
    }

    /**
     * @param value The number of vCPUs that you want to reserve for each node of this kdb cluster on the scaling group host.
     */
    @JvmName("ysfbdsubuknbehui")
    public suspend fun cpu(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cpu = mapped
    }

    /**
     * @param value An optional hard limit on the amount of memory a kdb cluster can use.
     */
    @JvmName("ifecwpoarteyqxjd")
    public suspend fun memoryLimit(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.memoryLimit = mapped
    }

    /**
     * @param value A reservation of the minimum amount of memory that should be available on the scaling group for a kdb cluster to be successfully placed in a scaling group.
     */
    @JvmName("wbmxbvmrstspbvtf")
    public suspend fun memoryReservation(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.memoryReservation = mapped
    }

    /**
     * @param value The number of kdb cluster nodes.
     */
    @JvmName("rgcenotkhkkwkuty")
    public suspend fun nodeCount(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.nodeCount = mapped
    }

    /**
     * @param value A unique identifier for the kdb scaling group.
     */
    @JvmName("rxfllhuwerpmduea")
    public suspend fun scalingGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.scalingGroupName = mapped
    }

    internal fun build(): KxClusterScalingGroupConfigurationArgs =
        KxClusterScalingGroupConfigurationArgs(
            cpu = cpu,
            memoryLimit = memoryLimit,
            memoryReservation = memoryReservation ?: throw PulumiNullFieldException("memoryReservation"),
            nodeCount = nodeCount ?: throw PulumiNullFieldException("nodeCount"),
            scalingGroupName = scalingGroupName ?: throw PulumiNullFieldException("scalingGroupName"),
        )
}
