@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.finspace.kotlin.inputs

import com.pulumi.aws.finspace.inputs.KxClusterTickerplantLogConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property tickerplantLogVolumes
 */
public data class KxClusterTickerplantLogConfigurationArgs(
    public val tickerplantLogVolumes: Output<List<String>>,
) : ConvertibleToJava<com.pulumi.aws.finspace.inputs.KxClusterTickerplantLogConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.finspace.inputs.KxClusterTickerplantLogConfigurationArgs =
        com.pulumi.aws.finspace.inputs.KxClusterTickerplantLogConfigurationArgs.builder()
            .tickerplantLogVolumes(
                tickerplantLogVolumes.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            ).build()
}

/**
 * Builder for [KxClusterTickerplantLogConfigurationArgs].
 */
@PulumiTagMarker
public class KxClusterTickerplantLogConfigurationArgsBuilder internal constructor() {
    private var tickerplantLogVolumes: Output<List<String>>? = null

    /**
     * @param value
     */
    @JvmName("xaqcecfgkiiucfce")
    public suspend fun tickerplantLogVolumes(`value`: Output<List<String>>) {
        this.tickerplantLogVolumes = value
    }

    @JvmName("gdulgskixsvyfxcn")
    public suspend fun tickerplantLogVolumes(vararg values: Output<String>) {
        this.tickerplantLogVolumes = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("wmkterleuhhslnwd")
    public suspend fun tickerplantLogVolumes(values: List<Output<String>>) {
        this.tickerplantLogVolumes = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("mmuhaqlaammrwrjj")
    public suspend fun tickerplantLogVolumes(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tickerplantLogVolumes = mapped
    }

    /**
     * @param values
     */
    @JvmName("pexkcuihrotrqnue")
    public suspend fun tickerplantLogVolumes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tickerplantLogVolumes = mapped
    }

    internal fun build(): KxClusterTickerplantLogConfigurationArgs =
        KxClusterTickerplantLogConfigurationArgs(
            tickerplantLogVolumes = tickerplantLogVolumes ?: throw
                PulumiNullFieldException("tickerplantLogVolumes"),
        )
}
