@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.finspace.kotlin.inputs

import com.pulumi.aws.finspace.inputs.KxDataviewSegmentConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property dbPaths The database path of the data that you want to place on each selected volume. Each segment must have a unique database path for each volume.
 * @property onDemand Enables on-demand caching on the selected database path when a particular file or a column of the database is accessed. When on demand caching is **True**, dataviews perform minimal loading of files on the filesystem as needed. When it is set to **False**, everything is cached. The default value is **False**.
 * @property volumeName The name of the volume that you want to attach to a dataview. This volume must be in the same availability zone as the dataview that you are attaching to.
 */
public data class KxDataviewSegmentConfigurationArgs(
    public val dbPaths: Output<List<String>>,
    public val onDemand: Output<Boolean>? = null,
    public val volumeName: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.finspace.inputs.KxDataviewSegmentConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.finspace.inputs.KxDataviewSegmentConfigurationArgs =
        com.pulumi.aws.finspace.inputs.KxDataviewSegmentConfigurationArgs.builder()
            .dbPaths(dbPaths.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .onDemand(onDemand?.applyValue({ args0 -> args0 }))
            .volumeName(volumeName.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [KxDataviewSegmentConfigurationArgs].
 */
@PulumiTagMarker
public class KxDataviewSegmentConfigurationArgsBuilder internal constructor() {
    private var dbPaths: Output<List<String>>? = null

    private var onDemand: Output<Boolean>? = null

    private var volumeName: Output<String>? = null

    /**
     * @param value The database path of the data that you want to place on each selected volume. Each segment must have a unique database path for each volume.
     */
    @JvmName("pcofswkheiiifyar")
    public suspend fun dbPaths(`value`: Output<List<String>>) {
        this.dbPaths = value
    }

    @JvmName("dirhmpmmrondspqt")
    public suspend fun dbPaths(vararg values: Output<String>) {
        this.dbPaths = Output.all(values.asList())
    }

    /**
     * @param values The database path of the data that you want to place on each selected volume. Each segment must have a unique database path for each volume.
     */
    @JvmName("xcomgodvsktfgljj")
    public suspend fun dbPaths(values: List<Output<String>>) {
        this.dbPaths = Output.all(values)
    }

    /**
     * @param value Enables on-demand caching on the selected database path when a particular file or a column of the database is accessed. When on demand caching is **True**, dataviews perform minimal loading of files on the filesystem as needed. When it is set to **False**, everything is cached. The default value is **False**.
     */
    @JvmName("obpuefhblsaxrwvw")
    public suspend fun onDemand(`value`: Output<Boolean>) {
        this.onDemand = value
    }

    /**
     * @param value The name of the volume that you want to attach to a dataview. This volume must be in the same availability zone as the dataview that you are attaching to.
     */
    @JvmName("ixomosfnuybjtpxe")
    public suspend fun volumeName(`value`: Output<String>) {
        this.volumeName = value
    }

    /**
     * @param value The database path of the data that you want to place on each selected volume. Each segment must have a unique database path for each volume.
     */
    @JvmName("ihwbbnhbvjgdxwkt")
    public suspend fun dbPaths(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dbPaths = mapped
    }

    /**
     * @param values The database path of the data that you want to place on each selected volume. Each segment must have a unique database path for each volume.
     */
    @JvmName("qatipctpymtbqttp")
    public suspend fun dbPaths(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dbPaths = mapped
    }

    /**
     * @param value Enables on-demand caching on the selected database path when a particular file or a column of the database is accessed. When on demand caching is **True**, dataviews perform minimal loading of files on the filesystem as needed. When it is set to **False**, everything is cached. The default value is **False**.
     */
    @JvmName("ocqjyenpubkvaasy")
    public suspend fun onDemand(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.onDemand = mapped
    }

    /**
     * @param value The name of the volume that you want to attach to a dataview. This volume must be in the same availability zone as the dataview that you are attaching to.
     */
    @JvmName("wdjkksfkonymyiqn")
    public suspend fun volumeName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.volumeName = mapped
    }

    internal fun build(): KxDataviewSegmentConfigurationArgs = KxDataviewSegmentConfigurationArgs(
        dbPaths = dbPaths ?: throw PulumiNullFieldException("dbPaths"),
        onDemand = onDemand,
        volumeName = volumeName ?: throw PulumiNullFieldException("volumeName"),
    )
}
