@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.finspace.kotlin.inputs

import com.pulumi.aws.finspace.inputs.KxEnvironmentCustomDnsConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property customDnsServerIp IP address of the DNS server.
 * @property customDnsServerName Name of the DNS server.
 */
public data class KxEnvironmentCustomDnsConfigurationArgs(
    public val customDnsServerIp: Output<String>,
    public val customDnsServerName: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.finspace.inputs.KxEnvironmentCustomDnsConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.finspace.inputs.KxEnvironmentCustomDnsConfigurationArgs =
        com.pulumi.aws.finspace.inputs.KxEnvironmentCustomDnsConfigurationArgs.builder()
            .customDnsServerIp(customDnsServerIp.applyValue({ args0 -> args0 }))
            .customDnsServerName(customDnsServerName.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [KxEnvironmentCustomDnsConfigurationArgs].
 */
@PulumiTagMarker
public class KxEnvironmentCustomDnsConfigurationArgsBuilder internal constructor() {
    private var customDnsServerIp: Output<String>? = null

    private var customDnsServerName: Output<String>? = null

    /**
     * @param value IP address of the DNS server.
     */
    @JvmName("fnvutwoudspdavwf")
    public suspend fun customDnsServerIp(`value`: Output<String>) {
        this.customDnsServerIp = value
    }

    /**
     * @param value Name of the DNS server.
     */
    @JvmName("alpfcvkkcksslody")
    public suspend fun customDnsServerName(`value`: Output<String>) {
        this.customDnsServerName = value
    }

    /**
     * @param value IP address of the DNS server.
     */
    @JvmName("luvceevygefgydcj")
    public suspend fun customDnsServerIp(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.customDnsServerIp = mapped
    }

    /**
     * @param value Name of the DNS server.
     */
    @JvmName("fkbaxmvlaouehqoo")
    public suspend fun customDnsServerName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.customDnsServerName = mapped
    }

    internal fun build(): KxEnvironmentCustomDnsConfigurationArgs =
        KxEnvironmentCustomDnsConfigurationArgs(
            customDnsServerIp = customDnsServerIp ?: throw PulumiNullFieldException("customDnsServerIp"),
            customDnsServerName = customDnsServerName ?: throw PulumiNullFieldException("customDnsServerName"),
        )
}
