@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.finspace.kotlin.inputs

import com.pulumi.aws.finspace.inputs.KxEnvironmentTransitGatewayConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property attachmentNetworkAclConfigurations Rules that define how you manage outbound traffic from kdb network to your internal network. Defined below.
 * @property routableCidrSpace Routing CIDR on behalf of KX environment. It could be any “/26 range in the 100.64.0.0 CIDR space. After providing, it will be added to the customer’s transit gateway routing table so that the traffics could be routed to KX network.
 * @property transitGatewayId Identifier of the transit gateway created by the customer to connect outbound traffics from KX network to your internal network.
 */
public data class KxEnvironmentTransitGatewayConfigurationArgs(
    public val attachmentNetworkAclConfigurations: Output<List<KxEnvironmentTransitGatewayConfigurationAttachmentNetworkAclConfigurationArgs>>? =
        null,
    public val routableCidrSpace: Output<String>,
    public val transitGatewayId: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.finspace.inputs.KxEnvironmentTransitGatewayConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.finspace.inputs.KxEnvironmentTransitGatewayConfigurationArgs = com.pulumi.aws.finspace.inputs.KxEnvironmentTransitGatewayConfigurationArgs.builder()
        .attachmentNetworkAclConfigurations(
            attachmentNetworkAclConfigurations?.applyValue({ args0 ->
                args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) })
            }),
        )
        .routableCidrSpace(routableCidrSpace.applyValue({ args0 -> args0 }))
        .transitGatewayId(transitGatewayId.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [KxEnvironmentTransitGatewayConfigurationArgs].
 */
@PulumiTagMarker
public class KxEnvironmentTransitGatewayConfigurationArgsBuilder internal constructor() {
    private var attachmentNetworkAclConfigurations:
        Output<List<KxEnvironmentTransitGatewayConfigurationAttachmentNetworkAclConfigurationArgs>>? =
        null

    private var routableCidrSpace: Output<String>? = null

    private var transitGatewayId: Output<String>? = null

    /**
     * @param value Rules that define how you manage outbound traffic from kdb network to your internal network. Defined below.
     */
    @JvmName("cwtpeicnvjgawrja")
    public suspend fun attachmentNetworkAclConfigurations(`value`: Output<List<KxEnvironmentTransitGatewayConfigurationAttachmentNetworkAclConfigurationArgs>>) {
        this.attachmentNetworkAclConfigurations = value
    }

    @JvmName("rtiajmljmpdcvkxv")
    public suspend fun attachmentNetworkAclConfigurations(vararg values: Output<KxEnvironmentTransitGatewayConfigurationAttachmentNetworkAclConfigurationArgs>) {
        this.attachmentNetworkAclConfigurations = Output.all(values.asList())
    }

    /**
     * @param values Rules that define how you manage outbound traffic from kdb network to your internal network. Defined below.
     */
    @JvmName("ibotcfdpfmoilydc")
    public suspend fun attachmentNetworkAclConfigurations(values: List<Output<KxEnvironmentTransitGatewayConfigurationAttachmentNetworkAclConfigurationArgs>>) {
        this.attachmentNetworkAclConfigurations = Output.all(values)
    }

    /**
     * @param value Routing CIDR on behalf of KX environment. It could be any “/26 range in the 100.64.0.0 CIDR space. After providing, it will be added to the customer’s transit gateway routing table so that the traffics could be routed to KX network.
     */
    @JvmName("wocbldksfvmqtalu")
    public suspend fun routableCidrSpace(`value`: Output<String>) {
        this.routableCidrSpace = value
    }

    /**
     * @param value Identifier of the transit gateway created by the customer to connect outbound traffics from KX network to your internal network.
     */
    @JvmName("uvhefotatlwrohgt")
    public suspend fun transitGatewayId(`value`: Output<String>) {
        this.transitGatewayId = value
    }

    /**
     * @param value Rules that define how you manage outbound traffic from kdb network to your internal network. Defined below.
     */
    @JvmName("irbqoiynphbbpwrj")
    public suspend fun attachmentNetworkAclConfigurations(`value`: List<KxEnvironmentTransitGatewayConfigurationAttachmentNetworkAclConfigurationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.attachmentNetworkAclConfigurations = mapped
    }

    /**
     * @param argument Rules that define how you manage outbound traffic from kdb network to your internal network. Defined below.
     */
    @JvmName("brdyqccfgtibakgi")
    public suspend fun attachmentNetworkAclConfigurations(argument: List<suspend KxEnvironmentTransitGatewayConfigurationAttachmentNetworkAclConfigurationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            KxEnvironmentTransitGatewayConfigurationAttachmentNetworkAclConfigurationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.attachmentNetworkAclConfigurations = mapped
    }

    /**
     * @param argument Rules that define how you manage outbound traffic from kdb network to your internal network. Defined below.
     */
    @JvmName("qnhxfetfmevvkhxr")
    public suspend fun attachmentNetworkAclConfigurations(vararg argument: suspend KxEnvironmentTransitGatewayConfigurationAttachmentNetworkAclConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            KxEnvironmentTransitGatewayConfigurationAttachmentNetworkAclConfigurationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.attachmentNetworkAclConfigurations = mapped
    }

    /**
     * @param argument Rules that define how you manage outbound traffic from kdb network to your internal network. Defined below.
     */
    @JvmName("yettchntmkxrmihq")
    public suspend fun attachmentNetworkAclConfigurations(argument: suspend KxEnvironmentTransitGatewayConfigurationAttachmentNetworkAclConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                KxEnvironmentTransitGatewayConfigurationAttachmentNetworkAclConfigurationArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.attachmentNetworkAclConfigurations = mapped
    }

    /**
     * @param values Rules that define how you manage outbound traffic from kdb network to your internal network. Defined below.
     */
    @JvmName("thacgbdkuswbsvmi")
    public suspend fun attachmentNetworkAclConfigurations(vararg values: KxEnvironmentTransitGatewayConfigurationAttachmentNetworkAclConfigurationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.attachmentNetworkAclConfigurations = mapped
    }

    /**
     * @param value Routing CIDR on behalf of KX environment. It could be any “/26 range in the 100.64.0.0 CIDR space. After providing, it will be added to the customer’s transit gateway routing table so that the traffics could be routed to KX network.
     */
    @JvmName("scxgowjkmlmscrfg")
    public suspend fun routableCidrSpace(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.routableCidrSpace = mapped
    }

    /**
     * @param value Identifier of the transit gateway created by the customer to connect outbound traffics from KX network to your internal network.
     */
    @JvmName("csqjysruiitccvee")
    public suspend fun transitGatewayId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.transitGatewayId = mapped
    }

    internal fun build(): KxEnvironmentTransitGatewayConfigurationArgs =
        KxEnvironmentTransitGatewayConfigurationArgs(
            attachmentNetworkAclConfigurations = attachmentNetworkAclConfigurations,
            routableCidrSpace = routableCidrSpace ?: throw PulumiNullFieldException("routableCidrSpace"),
            transitGatewayId = transitGatewayId ?: throw PulumiNullFieldException("transitGatewayId"),
        )
}
