@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.finspace.kotlin.inputs

import com.pulumi.aws.finspace.inputs.KxVolumeNas1ConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property size The size of the network attached storage.
 * @property type The type of the network attached storage.
 */
public data class KxVolumeNas1ConfigurationArgs(
    public val size: Output<Int>,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.finspace.inputs.KxVolumeNas1ConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.finspace.inputs.KxVolumeNas1ConfigurationArgs =
        com.pulumi.aws.finspace.inputs.KxVolumeNas1ConfigurationArgs.builder()
            .size(size.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [KxVolumeNas1ConfigurationArgs].
 */
@PulumiTagMarker
public class KxVolumeNas1ConfigurationArgsBuilder internal constructor() {
    private var size: Output<Int>? = null

    private var type: Output<String>? = null

    /**
     * @param value The size of the network attached storage.
     */
    @JvmName("bufhrywithmlbqym")
    public suspend fun size(`value`: Output<Int>) {
        this.size = value
    }

    /**
     * @param value The type of the network attached storage.
     */
    @JvmName("fniqhysafgafkyrr")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The size of the network attached storage.
     */
    @JvmName("mfiqieoccnqcefjw")
    public suspend fun size(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.size = mapped
    }

    /**
     * @param value The type of the network attached storage.
     */
    @JvmName("lpfpyklhddfpfrif")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): KxVolumeNas1ConfigurationArgs = KxVolumeNas1ConfigurationArgs(
        size = size ?: throw PulumiNullFieldException("size"),
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
