@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.finspace.kotlin.outputs

import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property autoScalingMetric Metric your cluster will track in order to scale in and out. For example, CPU_UTILIZATION_PERCENTAGE is the average CPU usage across all nodes in a cluster.
 * @property maxNodeCount Highest number of nodes to scale. Cannot be greater than 5
 * @property metricTarget Desired value of chosen `auto_scaling_metric`. When metric drops below this value, cluster will scale in. When metric goes above this value, cluster will scale out. Can be set between 0 and 100 percent.
 * @property minNodeCount Lowest number of nodes to scale. Must be at least 1 and less than the `max_node_count`. If nodes in cluster belong to multiple availability zones, then `min_node_count` must be at least 3.
 * @property scaleInCooldownSeconds Duration in seconds that FinSpace will wait after a scale in event before initiating another scaling event.
 * @property scaleOutCooldownSeconds Duration in seconds that FinSpace will wait after a scale out event before initiating another scaling event.
 */
public data class KxClusterAutoScalingConfiguration(
    public val autoScalingMetric: String,
    public val maxNodeCount: Int,
    public val metricTarget: Double,
    public val minNodeCount: Int,
    public val scaleInCooldownSeconds: Double,
    public val scaleOutCooldownSeconds: Double,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.finspace.outputs.KxClusterAutoScalingConfiguration): KxClusterAutoScalingConfiguration = KxClusterAutoScalingConfiguration(
            autoScalingMetric = javaType.autoScalingMetric(),
            maxNodeCount = javaType.maxNodeCount(),
            metricTarget = javaType.metricTarget(),
            minNodeCount = javaType.minNodeCount(),
            scaleInCooldownSeconds = javaType.scaleInCooldownSeconds(),
            scaleOutCooldownSeconds = javaType.scaleOutCooldownSeconds(),
        )
    }
}
