@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.finspace.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property cacheConfigurations Configuration details for the disk cache to increase performance reading from a KX database mounted to the cluster. See cache_configurations.
 * @property changesetId A unique identifier of the changeset that is associated with the cluster.
 * @property databaseName Name of the KX database.
 * @property dataviewName The name of the dataview to be used for caching historical data on disk. You cannot update to a different dataview name once a cluster is created. Use `lifecycle` `ignore_changes` for database to prevent any undesirable behaviors.
 */
public data class KxClusterDatabase(
    public val cacheConfigurations: List<KxClusterDatabaseCacheConfiguration>? = null,
    public val changesetId: String? = null,
    public val databaseName: String,
    public val dataviewName: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.finspace.outputs.KxClusterDatabase): KxClusterDatabase = KxClusterDatabase(
            cacheConfigurations = javaType.cacheConfigurations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.finspace.kotlin.outputs.KxClusterDatabaseCacheConfiguration.Companion.toKotlin(args0)
                })
            }),
            changesetId = javaType.changesetId().map({ args0 -> args0 }).orElse(null),
            databaseName = javaType.databaseName(),
            dataviewName = javaType.dataviewName().map({ args0 -> args0 }).orElse(null),
        )
    }
}
