@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.finspace.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property cacheType Type of disk cache.
 * @property dbPaths Paths within the database to cache.
 */
public data class KxClusterDatabaseCacheConfiguration(
    public val cacheType: String,
    public val dbPaths: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.finspace.outputs.KxClusterDatabaseCacheConfiguration): KxClusterDatabaseCacheConfiguration = KxClusterDatabaseCacheConfiguration(
            cacheType = javaType.cacheType(),
            dbPaths = javaType.dbPaths().map({ args0 -> args0 }),
        )
    }
}
