@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.finspace.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property size Size of temporary storage in gigabytes. Must be between 10 and 16000.
 * @property type Type of writeable storage space for temporarily storing your savedown data. The valid values are:
 * * SDS01 - This type represents 3000 IOPS and io2 ebs volume type.
 * @property volumeName The name of the kdb volume that you want to use as writeable save-down storage for clusters.
 */
public data class KxClusterSavedownStorageConfiguration(
    public val size: Int? = null,
    public val type: String? = null,
    public val volumeName: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.finspace.outputs.KxClusterSavedownStorageConfiguration): KxClusterSavedownStorageConfiguration = KxClusterSavedownStorageConfiguration(
            size = javaType.size().map({ args0 -> args0 }).orElse(null),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
            volumeName = javaType.volumeName().map({ args0 -> args0 }).orElse(null),
        )
    }
}
