@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.finspace.kotlin.outputs

import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property cpu The number of vCPUs that you want to reserve for each node of this kdb cluster on the scaling group host.
 * @property memoryLimit An optional hard limit on the amount of memory a kdb cluster can use.
 * @property memoryReservation A reservation of the minimum amount of memory that should be available on the scaling group for a kdb cluster to be successfully placed in a scaling group.
 * @property nodeCount The number of kdb cluster nodes.
 * @property scalingGroupName A unique identifier for the kdb scaling group.
 */
public data class KxClusterScalingGroupConfiguration(
    public val cpu: Double? = null,
    public val memoryLimit: Int? = null,
    public val memoryReservation: Int,
    public val nodeCount: Int,
    public val scalingGroupName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.finspace.outputs.KxClusterScalingGroupConfiguration): KxClusterScalingGroupConfiguration = KxClusterScalingGroupConfiguration(
            cpu = javaType.cpu().map({ args0 -> args0 }).orElse(null),
            memoryLimit = javaType.memoryLimit().map({ args0 -> args0 }).orElse(null),
            memoryReservation = javaType.memoryReservation(),
            nodeCount = javaType.nodeCount(),
            scalingGroupName = javaType.scalingGroupName(),
        )
    }
}
