@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.finspace.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property dbPaths The database path of the data that you want to place on each selected volume. Each segment must have a unique database path for each volume.
 * @property onDemand Enables on-demand caching on the selected database path when a particular file or a column of the database is accessed. When on demand caching is **True**, dataviews perform minimal loading of files on the filesystem as needed. When it is set to **False**, everything is cached. The default value is **False**.
 * @property volumeName The name of the volume that you want to attach to a dataview. This volume must be in the same availability zone as the dataview that you are attaching to.
 */
public data class KxDataviewSegmentConfiguration(
    public val dbPaths: List<String>,
    public val onDemand: Boolean? = null,
    public val volumeName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.finspace.outputs.KxDataviewSegmentConfiguration): KxDataviewSegmentConfiguration = KxDataviewSegmentConfiguration(
            dbPaths = javaType.dbPaths().map({ args0 -> args0 }),
            onDemand = javaType.onDemand().map({ args0 -> args0 }).orElse(null),
            volumeName = javaType.volumeName(),
        )
    }
}
