@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.fis.kotlin

import com.pulumi.aws.fis.kotlin.outputs.ExperimentTemplateAction
import com.pulumi.aws.fis.kotlin.outputs.ExperimentTemplateExperimentOptions
import com.pulumi.aws.fis.kotlin.outputs.ExperimentTemplateLogConfiguration
import com.pulumi.aws.fis.kotlin.outputs.ExperimentTemplateStopCondition
import com.pulumi.aws.fis.kotlin.outputs.ExperimentTemplateTarget
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.fis.kotlin.outputs.ExperimentTemplateAction.Companion.toKotlin as experimentTemplateActionToKotlin
import com.pulumi.aws.fis.kotlin.outputs.ExperimentTemplateExperimentOptions.Companion.toKotlin as experimentTemplateExperimentOptionsToKotlin
import com.pulumi.aws.fis.kotlin.outputs.ExperimentTemplateLogConfiguration.Companion.toKotlin as experimentTemplateLogConfigurationToKotlin
import com.pulumi.aws.fis.kotlin.outputs.ExperimentTemplateStopCondition.Companion.toKotlin as experimentTemplateStopConditionToKotlin
import com.pulumi.aws.fis.kotlin.outputs.ExperimentTemplateTarget.Companion.toKotlin as experimentTemplateTargetToKotlin

/**
 * Builder for [ExperimentTemplate].
 */
@PulumiTagMarker
public class ExperimentTemplateResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ExperimentTemplateArgs = ExperimentTemplateArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ExperimentTemplateArgsBuilder.() -> Unit) {
        val builder = ExperimentTemplateArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ExperimentTemplate {
        val builtJavaResource = com.pulumi.aws.fis.ExperimentTemplate(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ExperimentTemplate(builtJavaResource)
    }
}

/**
 * Provides an FIS Experiment Template, which can be used to run an experiment.
 * An experiment template contains one or more actions to run on specified targets during an experiment.
 * It also contains the stop conditions that prevent the experiment from going out of bounds.
 * See [Amazon Fault Injection Simulator](https://docs.aws.amazon.com/fis/index.html)
 * for more information.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.fis.ExperimentTemplate("example", {
 *     description: "example",
 *     roleArn: exampleAwsIamRole.arn,
 *     stopConditions: [{
 *         source: "none",
 *     }],
 *     actions: [{
 *         name: "example-action",
 *         actionId: "aws:ec2:terminate-instances",
 *         target: {
 *             key: "Instances",
 *             value: "example-target",
 *         },
 *     }],
 *     targets: [{
 *         name: "example-target",
 *         resourceType: "aws:ec2:instance",
 *         selectionMode: "COUNT(1)",
 *         resourceTags: [{
 *             key: "env",
 *             value: "example",
 *         }],
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.fis.ExperimentTemplate("example",
 *     description="example",
 *     role_arn=example_aws_iam_role["arn"],
 *     stop_conditions=[{
 *         "source": "none",
 *     }],
 *     actions=[{
 *         "name": "example-action",
 *         "action_id": "aws:ec2:terminate-instances",
 *         "target": {
 *             "key": "Instances",
 *             "value": "example-target",
 *         },
 *     }],
 *     targets=[{
 *         "name": "example-target",
 *         "resource_type": "aws:ec2:instance",
 *         "selection_mode": "COUNT(1)",
 *         "resource_tags": [{
 *             "key": "env",
 *             "value": "example",
 *         }],
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Fis.ExperimentTemplate("example", new()
 *     {
 *         Description = "example",
 *         RoleArn = exampleAwsIamRole.Arn,
 *         StopConditions = new[]
 *         {
 *             new Aws.Fis.Inputs.ExperimentTemplateStopConditionArgs
 *             {
 *                 Source = "none",
 *             },
 *         },
 *         Actions = new[]
 *         {
 *             new Aws.Fis.Inputs.ExperimentTemplateActionArgs
 *             {
 *                 Name = "example-action",
 *                 ActionId = "aws:ec2:terminate-instances",
 *                 Target = new Aws.Fis.Inputs.ExperimentTemplateActionTargetArgs
 *                 {
 *                     Key = "Instances",
 *                     Value = "example-target",
 *                 },
 *             },
 *         },
 *         Targets = new[]
 *         {
 *             new Aws.Fis.Inputs.ExperimentTemplateTargetArgs
 *             {
 *                 Name = "example-target",
 *                 ResourceType = "aws:ec2:instance",
 *                 SelectionMode = "COUNT(1)",
 *                 ResourceTags = new[]
 *                 {
 *                     new Aws.Fis.Inputs.ExperimentTemplateTargetResourceTagArgs
 *                     {
 *                         Key = "env",
 *                         Value = "example",
 *                     },
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/fis"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := fis.NewExperimentTemplate(ctx, "example", &fis.ExperimentTemplateArgs{
 * 			Description: pulumi.String("example"),
 * 			RoleArn:     pulumi.Any(exampleAwsIamRole.Arn),
 * 			StopConditions: fis.ExperimentTemplateStopConditionArray{
 * 				&fis.ExperimentTemplateStopConditionArgs{
 * 					Source: pulumi.String("none"),
 * 				},
 * 			},
 * 			Actions: fis.ExperimentTemplateActionArray{
 * 				&fis.ExperimentTemplateActionArgs{
 * 					Name:     pulumi.String("example-action"),
 * 					ActionId: pulumi.String("aws:ec2:terminate-instances"),
 * 					Target: &fis.ExperimentTemplateActionTargetArgs{
 * 						Key:   pulumi.String("Instances"),
 * 						Value: pulumi.String("example-target"),
 * 					},
 * 				},
 * 			},
 * 			Targets: fis.ExperimentTemplateTargetArray{
 * 				&fis.ExperimentTemplateTargetArgs{
 * 					Name:          pulumi.String("example-target"),
 * 					ResourceType:  pulumi.String("aws:ec2:instance"),
 * 					SelectionMode: pulumi.String("COUNT(1)"),
 * 					ResourceTags: fis.ExperimentTemplateTargetResourceTagArray{
 * 						&fis.ExperimentTemplateTargetResourceTagArgs{
 * 							Key:   pulumi.String("env"),
 * 							Value: pulumi.String("example"),
 * 						},
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.fis.ExperimentTemplate;
 * import com.pulumi.aws.fis.ExperimentTemplateArgs;
 * import com.pulumi.aws.fis.inputs.ExperimentTemplateStopConditionArgs;
 * import com.pulumi.aws.fis.inputs.ExperimentTemplateActionArgs;
 * import com.pulumi.aws.fis.inputs.ExperimentTemplateActionTargetArgs;
 * import com.pulumi.aws.fis.inputs.ExperimentTemplateTargetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ExperimentTemplate("example", ExperimentTemplateArgs.builder()
 *             .description("example")
 *             .roleArn(exampleAwsIamRole.arn())
 *             .stopConditions(ExperimentTemplateStopConditionArgs.builder()
 *                 .source("none")
 *                 .build())
 *             .actions(ExperimentTemplateActionArgs.builder()
 *                 .name("example-action")
 *                 .actionId("aws:ec2:terminate-instances")
 *                 .target(ExperimentTemplateActionTargetArgs.builder()
 *                     .key("Instances")
 *                     .value("example-target")
 *                     .build())
 *                 .build())
 *             .targets(ExperimentTemplateTargetArgs.builder()
 *                 .name("example-target")
 *                 .resourceType("aws:ec2:instance")
 *                 .selectionMode("COUNT(1)")
 *                 .resourceTags(ExperimentTemplateTargetResourceTagArgs.builder()
 *                     .key("env")
 *                     .value("example")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:fis:ExperimentTemplate
 *     properties:
 *       description: example
 *       roleArn: ${exampleAwsIamRole.arn}
 *       stopConditions:
 *         - source: none
 *       actions:
 *         - name: example-action
 *           actionId: aws:ec2:terminate-instances
 *           target:
 *             key: Instances
 *             value: example-target
 *       targets:
 *         - name: example-target
 *           resourceType: aws:ec2:instance
 *           selectionMode: COUNT(1)
 *           resourceTags:
 *             - key: env
 *               value: example
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import FIS Experiment Templates using the `id`. For example:
 * ```sh
 * $ pulumi import aws:fis/experimentTemplate:ExperimentTemplate template EXT123AbCdEfGhIjK
 * ```
 */
public class ExperimentTemplate internal constructor(
    override val javaResource: com.pulumi.aws.fis.ExperimentTemplate,
) : KotlinCustomResource(javaResource, ExperimentTemplateMapper) {
    /**
     * Action to be performed during an experiment. See below.
     */
    public val actions: Output<List<ExperimentTemplateAction>>
        get() = javaResource.actions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    experimentTemplateActionToKotlin(args0)
                })
            })
        })

    /**
     * Description for the experiment template.
     */
    public val description: Output<String>
        get() = javaResource.description().applyValue({ args0 -> args0 })

    /**
     * The experiment options for the experiment template. See experiment_options below for more details!
     */
    public val experimentOptions: Output<ExperimentTemplateExperimentOptions>
        get() = javaResource.experimentOptions().applyValue({ args0 ->
            args0.let({ args0 ->
                experimentTemplateExperimentOptionsToKotlin(args0)
            })
        })

    /**
     * The configuration for experiment logging. See below.
     */
    public val logConfiguration: Output<ExperimentTemplateLogConfiguration>?
        get() = javaResource.logConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> experimentTemplateLogConfigurationToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * ARN of an IAM role that grants the AWS FIS service permission to perform service actions on your behalf.
     */
    public val roleArn: Output<String>
        get() = javaResource.roleArn().applyValue({ args0 -> args0 })

    /**
     * When an ongoing experiment should be stopped. See below.
     * The following arguments are optional:
     */
    public val stopConditions: Output<List<ExperimentTemplateStopCondition>>
        get() = javaResource.stopConditions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> experimentTemplateStopConditionToKotlin(args0) })
            })
        })

    /**
     * Key-value mapping of tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * Target of an action. See below.
     */
    public val targets: Output<List<ExperimentTemplateTarget>>?
        get() = javaResource.targets().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> experimentTemplateTargetToKotlin(args0) })
                })
            }).orElse(null)
        })
}

public object ExperimentTemplateMapper : ResourceMapper<ExperimentTemplate> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.fis.ExperimentTemplate::class == javaResource::class

    override fun map(javaResource: Resource): ExperimentTemplate = ExperimentTemplate(
        javaResource as
            com.pulumi.aws.fis.ExperimentTemplate,
    )
}

/**
 * @see [ExperimentTemplate].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ExperimentTemplate].
 */
public suspend fun experimentTemplate(
    name: String,
    block: suspend ExperimentTemplateResourceBuilder.() -> Unit,
): ExperimentTemplate {
    val builder = ExperimentTemplateResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ExperimentTemplate].
 * @param name The _unique_ name of the resulting resource.
 */
public fun experimentTemplate(name: String): ExperimentTemplate {
    val builder = ExperimentTemplateResourceBuilder()
    builder.name(name)
    return builder.build()
}
