@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.fis.kotlin

import com.pulumi.aws.fis.ExperimentTemplateArgs.builder
import com.pulumi.aws.fis.kotlin.inputs.ExperimentTemplateActionArgs
import com.pulumi.aws.fis.kotlin.inputs.ExperimentTemplateActionArgsBuilder
import com.pulumi.aws.fis.kotlin.inputs.ExperimentTemplateExperimentOptionsArgs
import com.pulumi.aws.fis.kotlin.inputs.ExperimentTemplateExperimentOptionsArgsBuilder
import com.pulumi.aws.fis.kotlin.inputs.ExperimentTemplateLogConfigurationArgs
import com.pulumi.aws.fis.kotlin.inputs.ExperimentTemplateLogConfigurationArgsBuilder
import com.pulumi.aws.fis.kotlin.inputs.ExperimentTemplateStopConditionArgs
import com.pulumi.aws.fis.kotlin.inputs.ExperimentTemplateStopConditionArgsBuilder
import com.pulumi.aws.fis.kotlin.inputs.ExperimentTemplateTargetArgs
import com.pulumi.aws.fis.kotlin.inputs.ExperimentTemplateTargetArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an FIS Experiment Template, which can be used to run an experiment.
 * An experiment template contains one or more actions to run on specified targets during an experiment.
 * It also contains the stop conditions that prevent the experiment from going out of bounds.
 * See [Amazon Fault Injection Simulator](https://docs.aws.amazon.com/fis/index.html)
 * for more information.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.fis.ExperimentTemplate("example", {
 *     description: "example",
 *     roleArn: exampleAwsIamRole.arn,
 *     stopConditions: [{
 *         source: "none",
 *     }],
 *     actions: [{
 *         name: "example-action",
 *         actionId: "aws:ec2:terminate-instances",
 *         target: {
 *             key: "Instances",
 *             value: "example-target",
 *         },
 *     }],
 *     targets: [{
 *         name: "example-target",
 *         resourceType: "aws:ec2:instance",
 *         selectionMode: "COUNT(1)",
 *         resourceTags: [{
 *             key: "env",
 *             value: "example",
 *         }],
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.fis.ExperimentTemplate("example",
 *     description="example",
 *     role_arn=example_aws_iam_role["arn"],
 *     stop_conditions=[{
 *         "source": "none",
 *     }],
 *     actions=[{
 *         "name": "example-action",
 *         "action_id": "aws:ec2:terminate-instances",
 *         "target": {
 *             "key": "Instances",
 *             "value": "example-target",
 *         },
 *     }],
 *     targets=[{
 *         "name": "example-target",
 *         "resource_type": "aws:ec2:instance",
 *         "selection_mode": "COUNT(1)",
 *         "resource_tags": [{
 *             "key": "env",
 *             "value": "example",
 *         }],
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Fis.ExperimentTemplate("example", new()
 *     {
 *         Description = "example",
 *         RoleArn = exampleAwsIamRole.Arn,
 *         StopConditions = new[]
 *         {
 *             new Aws.Fis.Inputs.ExperimentTemplateStopConditionArgs
 *             {
 *                 Source = "none",
 *             },
 *         },
 *         Actions = new[]
 *         {
 *             new Aws.Fis.Inputs.ExperimentTemplateActionArgs
 *             {
 *                 Name = "example-action",
 *                 ActionId = "aws:ec2:terminate-instances",
 *                 Target = new Aws.Fis.Inputs.ExperimentTemplateActionTargetArgs
 *                 {
 *                     Key = "Instances",
 *                     Value = "example-target",
 *                 },
 *             },
 *         },
 *         Targets = new[]
 *         {
 *             new Aws.Fis.Inputs.ExperimentTemplateTargetArgs
 *             {
 *                 Name = "example-target",
 *                 ResourceType = "aws:ec2:instance",
 *                 SelectionMode = "COUNT(1)",
 *                 ResourceTags = new[]
 *                 {
 *                     new Aws.Fis.Inputs.ExperimentTemplateTargetResourceTagArgs
 *                     {
 *                         Key = "env",
 *                         Value = "example",
 *                     },
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/fis"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := fis.NewExperimentTemplate(ctx, "example", &fis.ExperimentTemplateArgs{
 * 			Description: pulumi.String("example"),
 * 			RoleArn:     pulumi.Any(exampleAwsIamRole.Arn),
 * 			StopConditions: fis.ExperimentTemplateStopConditionArray{
 * 				&fis.ExperimentTemplateStopConditionArgs{
 * 					Source: pulumi.String("none"),
 * 				},
 * 			},
 * 			Actions: fis.ExperimentTemplateActionArray{
 * 				&fis.ExperimentTemplateActionArgs{
 * 					Name:     pulumi.String("example-action"),
 * 					ActionId: pulumi.String("aws:ec2:terminate-instances"),
 * 					Target: &fis.ExperimentTemplateActionTargetArgs{
 * 						Key:   pulumi.String("Instances"),
 * 						Value: pulumi.String("example-target"),
 * 					},
 * 				},
 * 			},
 * 			Targets: fis.ExperimentTemplateTargetArray{
 * 				&fis.ExperimentTemplateTargetArgs{
 * 					Name:          pulumi.String("example-target"),
 * 					ResourceType:  pulumi.String("aws:ec2:instance"),
 * 					SelectionMode: pulumi.String("COUNT(1)"),
 * 					ResourceTags: fis.ExperimentTemplateTargetResourceTagArray{
 * 						&fis.ExperimentTemplateTargetResourceTagArgs{
 * 							Key:   pulumi.String("env"),
 * 							Value: pulumi.String("example"),
 * 						},
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.fis.ExperimentTemplate;
 * import com.pulumi.aws.fis.ExperimentTemplateArgs;
 * import com.pulumi.aws.fis.inputs.ExperimentTemplateStopConditionArgs;
 * import com.pulumi.aws.fis.inputs.ExperimentTemplateActionArgs;
 * import com.pulumi.aws.fis.inputs.ExperimentTemplateActionTargetArgs;
 * import com.pulumi.aws.fis.inputs.ExperimentTemplateTargetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ExperimentTemplate("example", ExperimentTemplateArgs.builder()
 *             .description("example")
 *             .roleArn(exampleAwsIamRole.arn())
 *             .stopConditions(ExperimentTemplateStopConditionArgs.builder()
 *                 .source("none")
 *                 .build())
 *             .actions(ExperimentTemplateActionArgs.builder()
 *                 .name("example-action")
 *                 .actionId("aws:ec2:terminate-instances")
 *                 .target(ExperimentTemplateActionTargetArgs.builder()
 *                     .key("Instances")
 *                     .value("example-target")
 *                     .build())
 *                 .build())
 *             .targets(ExperimentTemplateTargetArgs.builder()
 *                 .name("example-target")
 *                 .resourceType("aws:ec2:instance")
 *                 .selectionMode("COUNT(1)")
 *                 .resourceTags(ExperimentTemplateTargetResourceTagArgs.builder()
 *                     .key("env")
 *                     .value("example")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:fis:ExperimentTemplate
 *     properties:
 *       description: example
 *       roleArn: ${exampleAwsIamRole.arn}
 *       stopConditions:
 *         - source: none
 *       actions:
 *         - name: example-action
 *           actionId: aws:ec2:terminate-instances
 *           target:
 *             key: Instances
 *             value: example-target
 *       targets:
 *         - name: example-target
 *           resourceType: aws:ec2:instance
 *           selectionMode: COUNT(1)
 *           resourceTags:
 *             - key: env
 *               value: example
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import FIS Experiment Templates using the `id`. For example:
 * ```sh
 * $ pulumi import aws:fis/experimentTemplate:ExperimentTemplate template EXT123AbCdEfGhIjK
 * ```
 * @property actions Action to be performed during an experiment. See below.
 * @property description Description for the experiment template.
 * @property experimentOptions The experiment options for the experiment template. See experiment_options below for more details!
 * @property logConfiguration The configuration for experiment logging. See below.
 * @property roleArn ARN of an IAM role that grants the AWS FIS service permission to perform service actions on your behalf.
 * @property stopConditions When an ongoing experiment should be stopped. See below.
 * The following arguments are optional:
 * @property tags Key-value mapping of tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property targets Target of an action. See below.
 */
public data class ExperimentTemplateArgs(
    public val actions: Output<List<ExperimentTemplateActionArgs>>? = null,
    public val description: Output<String>? = null,
    public val experimentOptions: Output<ExperimentTemplateExperimentOptionsArgs>? = null,
    public val logConfiguration: Output<ExperimentTemplateLogConfigurationArgs>? = null,
    public val roleArn: Output<String>? = null,
    public val stopConditions: Output<List<ExperimentTemplateStopConditionArgs>>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val targets: Output<List<ExperimentTemplateTargetArgs>>? = null,
) : ConvertibleToJava<com.pulumi.aws.fis.ExperimentTemplateArgs> {
    override fun toJava(): com.pulumi.aws.fis.ExperimentTemplateArgs =
        com.pulumi.aws.fis.ExperimentTemplateArgs.builder()
            .actions(
                actions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .description(description?.applyValue({ args0 -> args0 }))
            .experimentOptions(experimentOptions?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .logConfiguration(logConfiguration?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .roleArn(roleArn?.applyValue({ args0 -> args0 }))
            .stopConditions(
                stopConditions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .targets(
                targets?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ExperimentTemplateArgs].
 */
@PulumiTagMarker
public class ExperimentTemplateArgsBuilder internal constructor() {
    private var actions: Output<List<ExperimentTemplateActionArgs>>? = null

    private var description: Output<String>? = null

    private var experimentOptions: Output<ExperimentTemplateExperimentOptionsArgs>? = null

    private var logConfiguration: Output<ExperimentTemplateLogConfigurationArgs>? = null

    private var roleArn: Output<String>? = null

    private var stopConditions: Output<List<ExperimentTemplateStopConditionArgs>>? = null

    private var tags: Output<Map<String, String>>? = null

    private var targets: Output<List<ExperimentTemplateTargetArgs>>? = null

    /**
     * @param value Action to be performed during an experiment. See below.
     */
    @JvmName("ixacrenfgxljwnmg")
    public suspend fun actions(`value`: Output<List<ExperimentTemplateActionArgs>>) {
        this.actions = value
    }

    @JvmName("usxyueuxcwooulfp")
    public suspend fun actions(vararg values: Output<ExperimentTemplateActionArgs>) {
        this.actions = Output.all(values.asList())
    }

    /**
     * @param values Action to be performed during an experiment. See below.
     */
    @JvmName("qdfmsoxpfdafouds")
    public suspend fun actions(values: List<Output<ExperimentTemplateActionArgs>>) {
        this.actions = Output.all(values)
    }

    /**
     * @param value Description for the experiment template.
     */
    @JvmName("wgjxlnekhrylgfqg")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The experiment options for the experiment template. See experiment_options below for more details!
     */
    @JvmName("qyfckaykdspqlecl")
    public suspend fun experimentOptions(`value`: Output<ExperimentTemplateExperimentOptionsArgs>) {
        this.experimentOptions = value
    }

    /**
     * @param value The configuration for experiment logging. See below.
     */
    @JvmName("rbipmucrrjuwowwc")
    public suspend fun logConfiguration(`value`: Output<ExperimentTemplateLogConfigurationArgs>) {
        this.logConfiguration = value
    }

    /**
     * @param value ARN of an IAM role that grants the AWS FIS service permission to perform service actions on your behalf.
     */
    @JvmName("negvgqylmqgwsbmu")
    public suspend fun roleArn(`value`: Output<String>) {
        this.roleArn = value
    }

    /**
     * @param value When an ongoing experiment should be stopped. See below.
     * The following arguments are optional:
     */
    @JvmName("sasohnqleorpmaxv")
    public suspend fun stopConditions(`value`: Output<List<ExperimentTemplateStopConditionArgs>>) {
        this.stopConditions = value
    }

    @JvmName("ggqpcvhpmgrvjswe")
    public suspend fun stopConditions(vararg values: Output<ExperimentTemplateStopConditionArgs>) {
        this.stopConditions = Output.all(values.asList())
    }

    /**
     * @param values When an ongoing experiment should be stopped. See below.
     * The following arguments are optional:
     */
    @JvmName("kcskpqjoqxwtgsda")
    public suspend fun stopConditions(values: List<Output<ExperimentTemplateStopConditionArgs>>) {
        this.stopConditions = Output.all(values)
    }

    /**
     * @param value Key-value mapping of tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("djneuxkmlqgvfxqc")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Target of an action. See below.
     */
    @JvmName("cuxueopdrmxeaddd")
    public suspend fun targets(`value`: Output<List<ExperimentTemplateTargetArgs>>) {
        this.targets = value
    }

    @JvmName("glvvoonaiadnvxfb")
    public suspend fun targets(vararg values: Output<ExperimentTemplateTargetArgs>) {
        this.targets = Output.all(values.asList())
    }

    /**
     * @param values Target of an action. See below.
     */
    @JvmName("okswnqsnrkdvxlow")
    public suspend fun targets(values: List<Output<ExperimentTemplateTargetArgs>>) {
        this.targets = Output.all(values)
    }

    /**
     * @param value Action to be performed during an experiment. See below.
     */
    @JvmName("xpwlyigcktdxscxw")
    public suspend fun actions(`value`: List<ExperimentTemplateActionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.actions = mapped
    }

    /**
     * @param argument Action to be performed during an experiment. See below.
     */
    @JvmName("ettndkrxbkbogvne")
    public suspend fun actions(argument: List<suspend ExperimentTemplateActionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ExperimentTemplateActionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.actions = mapped
    }

    /**
     * @param argument Action to be performed during an experiment. See below.
     */
    @JvmName("pkbtpabpsvpwpxyj")
    public suspend fun actions(vararg argument: suspend ExperimentTemplateActionArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ExperimentTemplateActionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.actions = mapped
    }

    /**
     * @param argument Action to be performed during an experiment. See below.
     */
    @JvmName("llwcrmrjaypumeps")
    public suspend fun actions(argument: suspend ExperimentTemplateActionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ExperimentTemplateActionArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.actions = mapped
    }

    /**
     * @param values Action to be performed during an experiment. See below.
     */
    @JvmName("ovnxfvtfbgympgwp")
    public suspend fun actions(vararg values: ExperimentTemplateActionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.actions = mapped
    }

    /**
     * @param value Description for the experiment template.
     */
    @JvmName("iawttdsubuicvvsp")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The experiment options for the experiment template. See experiment_options below for more details!
     */
    @JvmName("amodettxlvlbxbnh")
    public suspend fun experimentOptions(`value`: ExperimentTemplateExperimentOptionsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.experimentOptions = mapped
    }

    /**
     * @param argument The experiment options for the experiment template. See experiment_options below for more details!
     */
    @JvmName("ttlibjmvsnuaswiq")
    public suspend fun experimentOptions(argument: suspend ExperimentTemplateExperimentOptionsArgsBuilder.() -> Unit) {
        val toBeMapped = ExperimentTemplateExperimentOptionsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.experimentOptions = mapped
    }

    /**
     * @param value The configuration for experiment logging. See below.
     */
    @JvmName("fxograbxmnwfbidp")
    public suspend fun logConfiguration(`value`: ExperimentTemplateLogConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logConfiguration = mapped
    }

    /**
     * @param argument The configuration for experiment logging. See below.
     */
    @JvmName("jjfoxkduoatjqcxy")
    public suspend fun logConfiguration(argument: suspend ExperimentTemplateLogConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = ExperimentTemplateLogConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.logConfiguration = mapped
    }

    /**
     * @param value ARN of an IAM role that grants the AWS FIS service permission to perform service actions on your behalf.
     */
    @JvmName("oxgvoaiqravofsns")
    public suspend fun roleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.roleArn = mapped
    }

    /**
     * @param value When an ongoing experiment should be stopped. See below.
     * The following arguments are optional:
     */
    @JvmName("wrrstitimnxpmnvc")
    public suspend fun stopConditions(`value`: List<ExperimentTemplateStopConditionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.stopConditions = mapped
    }

    /**
     * @param argument When an ongoing experiment should be stopped. See below.
     * The following arguments are optional:
     */
    @JvmName("dmfnlmlkqchjpiqg")
    public suspend fun stopConditions(argument: List<suspend ExperimentTemplateStopConditionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ExperimentTemplateStopConditionArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.stopConditions = mapped
    }

    /**
     * @param argument When an ongoing experiment should be stopped. See below.
     * The following arguments are optional:
     */
    @JvmName("pntlsjhkdnsnyvch")
    public suspend fun stopConditions(vararg argument: suspend ExperimentTemplateStopConditionArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ExperimentTemplateStopConditionArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.stopConditions = mapped
    }

    /**
     * @param argument When an ongoing experiment should be stopped. See below.
     * The following arguments are optional:
     */
    @JvmName("otuhmybrbqclejfv")
    public suspend fun stopConditions(argument: suspend ExperimentTemplateStopConditionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ExperimentTemplateStopConditionArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.stopConditions = mapped
    }

    /**
     * @param values When an ongoing experiment should be stopped. See below.
     * The following arguments are optional:
     */
    @JvmName("vsppcnkpjskcmctw")
    public suspend fun stopConditions(vararg values: ExperimentTemplateStopConditionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.stopConditions = mapped
    }

    /**
     * @param value Key-value mapping of tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("rbohdhjfirlbjhmm")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value mapping of tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("cbstpmdybvpocgak")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Target of an action. See below.
     */
    @JvmName("cqfoewrdjgbupipq")
    public suspend fun targets(`value`: List<ExperimentTemplateTargetArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targets = mapped
    }

    /**
     * @param argument Target of an action. See below.
     */
    @JvmName("ojwsdwkpmcprbybc")
    public suspend fun targets(argument: List<suspend ExperimentTemplateTargetArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ExperimentTemplateTargetArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.targets = mapped
    }

    /**
     * @param argument Target of an action. See below.
     */
    @JvmName("dvushstuucgnkrhx")
    public suspend fun targets(vararg argument: suspend ExperimentTemplateTargetArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ExperimentTemplateTargetArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.targets = mapped
    }

    /**
     * @param argument Target of an action. See below.
     */
    @JvmName("xnyonbhqspbpbnbo")
    public suspend fun targets(argument: suspend ExperimentTemplateTargetArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ExperimentTemplateTargetArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.targets = mapped
    }

    /**
     * @param values Target of an action. See below.
     */
    @JvmName("kobwpckgphlqdihg")
    public suspend fun targets(vararg values: ExperimentTemplateTargetArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targets = mapped
    }

    internal fun build(): ExperimentTemplateArgs = ExperimentTemplateArgs(
        actions = actions,
        description = description,
        experimentOptions = experimentOptions,
        logConfiguration = logConfiguration,
        roleArn = roleArn,
        stopConditions = stopConditions,
        tags = tags,
        targets = targets,
    )
}
