@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.fis.kotlin.inputs

import com.pulumi.aws.fis.inputs.ExperimentTemplateActionParameterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property key Parameter name.
 * @property value Parameter value.
 * For a list of parameters supported by each action, see [AWS FIS actions reference](https://docs.aws.amazon.com/fis/latest/userguide/fis-actions-reference.html).
 */
public data class ExperimentTemplateActionParameterArgs(
    public val key: Output<String>,
    public val `value`: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.fis.inputs.ExperimentTemplateActionParameterArgs> {
    override fun toJava(): com.pulumi.aws.fis.inputs.ExperimentTemplateActionParameterArgs =
        com.pulumi.aws.fis.inputs.ExperimentTemplateActionParameterArgs.builder()
            .key(key.applyValue({ args0 -> args0 }))
            .`value`(`value`.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ExperimentTemplateActionParameterArgs].
 */
@PulumiTagMarker
public class ExperimentTemplateActionParameterArgsBuilder internal constructor() {
    private var key: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value Parameter name.
     */
    @JvmName("aiwsxwpxfqmqnuhy")
    public suspend fun key(`value`: Output<String>) {
        this.key = value
    }

    /**
     * @param value Parameter value.
     * For a list of parameters supported by each action, see [AWS FIS actions reference](https://docs.aws.amazon.com/fis/latest/userguide/fis-actions-reference.html).
     */
    @JvmName("bfbxlumurvynpeop")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value Parameter name.
     */
    @JvmName("jsldqlxtxrisjhhh")
    public suspend fun key(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.key = mapped
    }

    /**
     * @param value Parameter value.
     * For a list of parameters supported by each action, see [AWS FIS actions reference](https://docs.aws.amazon.com/fis/latest/userguide/fis-actions-reference.html).
     */
    @JvmName("kqlmvcfiflihpbff")
    public suspend fun `value`(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): ExperimentTemplateActionParameterArgs =
        ExperimentTemplateActionParameterArgs(
            key = key ?: throw PulumiNullFieldException("key"),
            `value` = `value` ?: throw PulumiNullFieldException("value"),
        )
}
