@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.fis.kotlin.inputs

import com.pulumi.aws.fis.inputs.ExperimentTemplateExperimentOptionsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property accountTargeting Specifies the account targeting setting for experiment options. Supports `single-account` and `multi-account`.
 * @property emptyTargetResolutionMode Specifies the empty target resolution mode for experiment options. Supports `fail` and `skip`.
 */
public data class ExperimentTemplateExperimentOptionsArgs(
    public val accountTargeting: Output<String>? = null,
    public val emptyTargetResolutionMode: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.fis.inputs.ExperimentTemplateExperimentOptionsArgs> {
    override fun toJava(): com.pulumi.aws.fis.inputs.ExperimentTemplateExperimentOptionsArgs =
        com.pulumi.aws.fis.inputs.ExperimentTemplateExperimentOptionsArgs.builder()
            .accountTargeting(accountTargeting?.applyValue({ args0 -> args0 }))
            .emptyTargetResolutionMode(emptyTargetResolutionMode?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ExperimentTemplateExperimentOptionsArgs].
 */
@PulumiTagMarker
public class ExperimentTemplateExperimentOptionsArgsBuilder internal constructor() {
    private var accountTargeting: Output<String>? = null

    private var emptyTargetResolutionMode: Output<String>? = null

    /**
     * @param value Specifies the account targeting setting for experiment options. Supports `single-account` and `multi-account`.
     */
    @JvmName("hjepdrojlftlroxw")
    public suspend fun accountTargeting(`value`: Output<String>) {
        this.accountTargeting = value
    }

    /**
     * @param value Specifies the empty target resolution mode for experiment options. Supports `fail` and `skip`.
     */
    @JvmName("anolpxlwrwltuhif")
    public suspend fun emptyTargetResolutionMode(`value`: Output<String>) {
        this.emptyTargetResolutionMode = value
    }

    /**
     * @param value Specifies the account targeting setting for experiment options. Supports `single-account` and `multi-account`.
     */
    @JvmName("ouqmjyclyteuxcfm")
    public suspend fun accountTargeting(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountTargeting = mapped
    }

    /**
     * @param value Specifies the empty target resolution mode for experiment options. Supports `fail` and `skip`.
     */
    @JvmName("ijackelfroubtmhu")
    public suspend fun emptyTargetResolutionMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.emptyTargetResolutionMode = mapped
    }

    internal fun build(): ExperimentTemplateExperimentOptionsArgs =
        ExperimentTemplateExperimentOptionsArgs(
            accountTargeting = accountTargeting,
            emptyTargetResolutionMode = emptyTargetResolutionMode,
        )
}
