@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.fis.kotlin.inputs

import com.pulumi.aws.fis.inputs.ExperimentTemplateLogConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property cloudwatchLogsConfiguration The configuration for experiment logging to Amazon CloudWatch Logs. See below.
 * @property logSchemaVersion The schema version. See [documentation](https://docs.aws.amazon.com/fis/latest/userguide/monitoring-logging.html#experiment-log-schema) for the list of schema versions.
 * @property s3Configuration The configuration for experiment logging to Amazon S3. See below.
 */
public data class ExperimentTemplateLogConfigurationArgs(
    public val cloudwatchLogsConfiguration: Output<ExperimentTemplateLogConfigurationCloudwatchLogsConfigurationArgs>? = null,
    public val logSchemaVersion: Output<Int>,
    public val s3Configuration: Output<ExperimentTemplateLogConfigurationS3ConfigurationArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.fis.inputs.ExperimentTemplateLogConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.fis.inputs.ExperimentTemplateLogConfigurationArgs =
        com.pulumi.aws.fis.inputs.ExperimentTemplateLogConfigurationArgs.builder()
            .cloudwatchLogsConfiguration(
                cloudwatchLogsConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .logSchemaVersion(logSchemaVersion.applyValue({ args0 -> args0 }))
            .s3Configuration(
                s3Configuration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [ExperimentTemplateLogConfigurationArgs].
 */
@PulumiTagMarker
public class ExperimentTemplateLogConfigurationArgsBuilder internal constructor() {
    private var cloudwatchLogsConfiguration:
        Output<ExperimentTemplateLogConfigurationCloudwatchLogsConfigurationArgs>? = null

    private var logSchemaVersion: Output<Int>? = null

    private var s3Configuration: Output<ExperimentTemplateLogConfigurationS3ConfigurationArgs>? = null

    /**
     * @param value The configuration for experiment logging to Amazon CloudWatch Logs. See below.
     */
    @JvmName("atervnbinufbuaxx")
    public suspend fun cloudwatchLogsConfiguration(`value`: Output<ExperimentTemplateLogConfigurationCloudwatchLogsConfigurationArgs>) {
        this.cloudwatchLogsConfiguration = value
    }

    /**
     * @param value The schema version. See [documentation](https://docs.aws.amazon.com/fis/latest/userguide/monitoring-logging.html#experiment-log-schema) for the list of schema versions.
     */
    @JvmName("nnrrtvokodvujhcj")
    public suspend fun logSchemaVersion(`value`: Output<Int>) {
        this.logSchemaVersion = value
    }

    /**
     * @param value The configuration for experiment logging to Amazon S3. See below.
     */
    @JvmName("vywrmviunlsgkftc")
    public suspend fun s3Configuration(`value`: Output<ExperimentTemplateLogConfigurationS3ConfigurationArgs>) {
        this.s3Configuration = value
    }

    /**
     * @param value The configuration for experiment logging to Amazon CloudWatch Logs. See below.
     */
    @JvmName("jciwyaogxhbrwldg")
    public suspend fun cloudwatchLogsConfiguration(`value`: ExperimentTemplateLogConfigurationCloudwatchLogsConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cloudwatchLogsConfiguration = mapped
    }

    /**
     * @param argument The configuration for experiment logging to Amazon CloudWatch Logs. See below.
     */
    @JvmName("ckluuxpuhqgjpbpk")
    public suspend fun cloudwatchLogsConfiguration(argument: suspend ExperimentTemplateLogConfigurationCloudwatchLogsConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped =
            ExperimentTemplateLogConfigurationCloudwatchLogsConfigurationArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.cloudwatchLogsConfiguration = mapped
    }

    /**
     * @param value The schema version. See [documentation](https://docs.aws.amazon.com/fis/latest/userguide/monitoring-logging.html#experiment-log-schema) for the list of schema versions.
     */
    @JvmName("htcahmaloouprvrn")
    public suspend fun logSchemaVersion(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.logSchemaVersion = mapped
    }

    /**
     * @param value The configuration for experiment logging to Amazon S3. See below.
     */
    @JvmName("ymedoaglhhdcayaq")
    public suspend fun s3Configuration(`value`: ExperimentTemplateLogConfigurationS3ConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.s3Configuration = mapped
    }

    /**
     * @param argument The configuration for experiment logging to Amazon S3. See below.
     */
    @JvmName("tlhcqfkubamfvvag")
    public suspend fun s3Configuration(argument: suspend ExperimentTemplateLogConfigurationS3ConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = ExperimentTemplateLogConfigurationS3ConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.s3Configuration = mapped
    }

    internal fun build(): ExperimentTemplateLogConfigurationArgs =
        ExperimentTemplateLogConfigurationArgs(
            cloudwatchLogsConfiguration = cloudwatchLogsConfiguration,
            logSchemaVersion = logSchemaVersion ?: throw PulumiNullFieldException("logSchemaVersion"),
            s3Configuration = s3Configuration,
        )
}
