@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.fis.kotlin.inputs

import com.pulumi.aws.fis.inputs.ExperimentTemplateLogConfigurationS3ConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property bucketName The name of the destination bucket.
 * @property prefix The bucket prefix.
 */
public data class ExperimentTemplateLogConfigurationS3ConfigurationArgs(
    public val bucketName: Output<String>,
    public val prefix: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.fis.inputs.ExperimentTemplateLogConfigurationS3ConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.fis.inputs.ExperimentTemplateLogConfigurationS3ConfigurationArgs =
        com.pulumi.aws.fis.inputs.ExperimentTemplateLogConfigurationS3ConfigurationArgs.builder()
            .bucketName(bucketName.applyValue({ args0 -> args0 }))
            .prefix(prefix?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ExperimentTemplateLogConfigurationS3ConfigurationArgs].
 */
@PulumiTagMarker
public class ExperimentTemplateLogConfigurationS3ConfigurationArgsBuilder internal constructor() {
    private var bucketName: Output<String>? = null

    private var prefix: Output<String>? = null

    /**
     * @param value The name of the destination bucket.
     */
    @JvmName("rwtxhtmigoapqsld")
    public suspend fun bucketName(`value`: Output<String>) {
        this.bucketName = value
    }

    /**
     * @param value The bucket prefix.
     */
    @JvmName("nblecolwfionkmte")
    public suspend fun prefix(`value`: Output<String>) {
        this.prefix = value
    }

    /**
     * @param value The name of the destination bucket.
     */
    @JvmName("ydfkjpkdmfamjtfh")
    public suspend fun bucketName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.bucketName = mapped
    }

    /**
     * @param value The bucket prefix.
     */
    @JvmName("qimdsaoxdpavilgu")
    public suspend fun prefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.prefix = mapped
    }

    internal fun build(): ExperimentTemplateLogConfigurationS3ConfigurationArgs =
        ExperimentTemplateLogConfigurationS3ConfigurationArgs(
            bucketName = bucketName ?: throw PulumiNullFieldException("bucketName"),
            prefix = prefix,
        )
}
