@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.fis.kotlin.inputs

import com.pulumi.aws.fis.inputs.ExperimentTemplateTargetArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * @property filters Filter(s) for the target. Filters can be used to select resources based on specific attributes returned by the respective describe action of the resource type. For more information, see [Targets for AWS FIS](https://docs.aws.amazon.com/fis/latest/userguide/targets.html#target-filters). See below.
 * @property name Friendly name given to the target.
 * @property parameters The resource type parameters.
 * > **NOTE:** The `target` configuration block requires either `resource_arns` or `resource_tag`.
 * @property resourceArns Set of ARNs of the resources to target with an action. Conflicts with `resource_tag`.
 * @property resourceTags Tag(s) the resources need to have to be considered a valid target for an action. Conflicts with `resource_arns`. See below.
 * @property resourceType AWS resource type. The resource type must be supported for the specified action. To find out what resource types are supported, see [Targets for AWS FIS](https://docs.aws.amazon.com/fis/latest/userguide/targets.html#resource-types).
 * @property selectionMode Scopes the identified resources. Valid values are `ALL` (all identified resources), `COUNT(n)` (randomly select `n` of the identified resources), `PERCENT(n)` (randomly select `n` percent of the identified resources).
 */
public data class ExperimentTemplateTargetArgs(
    public val filters: Output<List<ExperimentTemplateTargetFilterArgs>>? = null,
    public val name: Output<String>,
    public val parameters: Output<Map<String, String>>? = null,
    public val resourceArns: Output<List<String>>? = null,
    public val resourceTags: Output<List<ExperimentTemplateTargetResourceTagArgs>>? = null,
    public val resourceType: Output<String>,
    public val selectionMode: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.fis.inputs.ExperimentTemplateTargetArgs> {
    override fun toJava(): com.pulumi.aws.fis.inputs.ExperimentTemplateTargetArgs =
        com.pulumi.aws.fis.inputs.ExperimentTemplateTargetArgs.builder()
            .filters(
                filters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .name(name.applyValue({ args0 -> args0 }))
            .parameters(
                parameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .resourceArns(resourceArns?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .resourceTags(
                resourceTags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .resourceType(resourceType.applyValue({ args0 -> args0 }))
            .selectionMode(selectionMode.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ExperimentTemplateTargetArgs].
 */
@PulumiTagMarker
public class ExperimentTemplateTargetArgsBuilder internal constructor() {
    private var filters: Output<List<ExperimentTemplateTargetFilterArgs>>? = null

    private var name: Output<String>? = null

    private var parameters: Output<Map<String, String>>? = null

    private var resourceArns: Output<List<String>>? = null

    private var resourceTags: Output<List<ExperimentTemplateTargetResourceTagArgs>>? = null

    private var resourceType: Output<String>? = null

    private var selectionMode: Output<String>? = null

    /**
     * @param value Filter(s) for the target. Filters can be used to select resources based on specific attributes returned by the respective describe action of the resource type. For more information, see [Targets for AWS FIS](https://docs.aws.amazon.com/fis/latest/userguide/targets.html#target-filters). See below.
     */
    @JvmName("gxiuoxagiwloyinn")
    public suspend fun filters(`value`: Output<List<ExperimentTemplateTargetFilterArgs>>) {
        this.filters = value
    }

    @JvmName("cinucwbaiihurucj")
    public suspend fun filters(vararg values: Output<ExperimentTemplateTargetFilterArgs>) {
        this.filters = Output.all(values.asList())
    }

    /**
     * @param values Filter(s) for the target. Filters can be used to select resources based on specific attributes returned by the respective describe action of the resource type. For more information, see [Targets for AWS FIS](https://docs.aws.amazon.com/fis/latest/userguide/targets.html#target-filters). See below.
     */
    @JvmName("mimqjnvirwxbxrsg")
    public suspend fun filters(values: List<Output<ExperimentTemplateTargetFilterArgs>>) {
        this.filters = Output.all(values)
    }

    /**
     * @param value Friendly name given to the target.
     */
    @JvmName("ixxpcmwrucoicelt")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The resource type parameters.
     * > **NOTE:** The `target` configuration block requires either `resource_arns` or `resource_tag`.
     */
    @JvmName("pgskgomobypxyewg")
    public suspend fun parameters(`value`: Output<Map<String, String>>) {
        this.parameters = value
    }

    /**
     * @param value Set of ARNs of the resources to target with an action. Conflicts with `resource_tag`.
     */
    @JvmName("rjltpcixsolucvva")
    public suspend fun resourceArns(`value`: Output<List<String>>) {
        this.resourceArns = value
    }

    @JvmName("gxcvyffndjhirfxu")
    public suspend fun resourceArns(vararg values: Output<String>) {
        this.resourceArns = Output.all(values.asList())
    }

    /**
     * @param values Set of ARNs of the resources to target with an action. Conflicts with `resource_tag`.
     */
    @JvmName("bmuesawnpwffdugx")
    public suspend fun resourceArns(values: List<Output<String>>) {
        this.resourceArns = Output.all(values)
    }

    /**
     * @param value Tag(s) the resources need to have to be considered a valid target for an action. Conflicts with `resource_arns`. See below.
     */
    @JvmName("cgwelrormjfkryln")
    public suspend fun resourceTags(`value`: Output<List<ExperimentTemplateTargetResourceTagArgs>>) {
        this.resourceTags = value
    }

    @JvmName("rodpvpoblwjgpeio")
    public suspend fun resourceTags(vararg values: Output<ExperimentTemplateTargetResourceTagArgs>) {
        this.resourceTags = Output.all(values.asList())
    }

    /**
     * @param values Tag(s) the resources need to have to be considered a valid target for an action. Conflicts with `resource_arns`. See below.
     */
    @JvmName("rmhkytkycvcbejfa")
    public suspend fun resourceTags(values: List<Output<ExperimentTemplateTargetResourceTagArgs>>) {
        this.resourceTags = Output.all(values)
    }

    /**
     * @param value AWS resource type. The resource type must be supported for the specified action. To find out what resource types are supported, see [Targets for AWS FIS](https://docs.aws.amazon.com/fis/latest/userguide/targets.html#resource-types).
     */
    @JvmName("urxyvecbfuparhdp")
    public suspend fun resourceType(`value`: Output<String>) {
        this.resourceType = value
    }

    /**
     * @param value Scopes the identified resources. Valid values are `ALL` (all identified resources), `COUNT(n)` (randomly select `n` of the identified resources), `PERCENT(n)` (randomly select `n` percent of the identified resources).
     */
    @JvmName("bhbnibrlcjqdckos")
    public suspend fun selectionMode(`value`: Output<String>) {
        this.selectionMode = value
    }

    /**
     * @param value Filter(s) for the target. Filters can be used to select resources based on specific attributes returned by the respective describe action of the resource type. For more information, see [Targets for AWS FIS](https://docs.aws.amazon.com/fis/latest/userguide/targets.html#target-filters). See below.
     */
    @JvmName("sofhbysnxefbakop")
    public suspend fun filters(`value`: List<ExperimentTemplateTargetFilterArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.filters = mapped
    }

    /**
     * @param argument Filter(s) for the target. Filters can be used to select resources based on specific attributes returned by the respective describe action of the resource type. For more information, see [Targets for AWS FIS](https://docs.aws.amazon.com/fis/latest/userguide/targets.html#target-filters). See below.
     */
    @JvmName("cnwfswamvqlqqsbf")
    public suspend fun filters(argument: List<suspend ExperimentTemplateTargetFilterArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ExperimentTemplateTargetFilterArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.filters = mapped
    }

    /**
     * @param argument Filter(s) for the target. Filters can be used to select resources based on specific attributes returned by the respective describe action of the resource type. For more information, see [Targets for AWS FIS](https://docs.aws.amazon.com/fis/latest/userguide/targets.html#target-filters). See below.
     */
    @JvmName("wqcpydseskkqwosx")
    public suspend fun filters(vararg argument: suspend ExperimentTemplateTargetFilterArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ExperimentTemplateTargetFilterArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.filters = mapped
    }

    /**
     * @param argument Filter(s) for the target. Filters can be used to select resources based on specific attributes returned by the respective describe action of the resource type. For more information, see [Targets for AWS FIS](https://docs.aws.amazon.com/fis/latest/userguide/targets.html#target-filters). See below.
     */
    @JvmName("ewlujpvaphpymhdu")
    public suspend fun filters(argument: suspend ExperimentTemplateTargetFilterArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ExperimentTemplateTargetFilterArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.filters = mapped
    }

    /**
     * @param values Filter(s) for the target. Filters can be used to select resources based on specific attributes returned by the respective describe action of the resource type. For more information, see [Targets for AWS FIS](https://docs.aws.amazon.com/fis/latest/userguide/targets.html#target-filters). See below.
     */
    @JvmName("luuchdvjgiscedfs")
    public suspend fun filters(vararg values: ExperimentTemplateTargetFilterArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.filters = mapped
    }

    /**
     * @param value Friendly name given to the target.
     */
    @JvmName("pmgvlyqwflinyjpe")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The resource type parameters.
     * > **NOTE:** The `target` configuration block requires either `resource_arns` or `resource_tag`.
     */
    @JvmName("eltkinvvijfiaofm")
    public suspend fun parameters(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param values The resource type parameters.
     * > **NOTE:** The `target` configuration block requires either `resource_arns` or `resource_tag`.
     */
    @JvmName("ntgxrnunffijvpde")
    public fun parameters(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value Set of ARNs of the resources to target with an action. Conflicts with `resource_tag`.
     */
    @JvmName("syxojuxxnfmmxsgj")
    public suspend fun resourceArns(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceArns = mapped
    }

    /**
     * @param values Set of ARNs of the resources to target with an action. Conflicts with `resource_tag`.
     */
    @JvmName("lerxumhunmifoirg")
    public suspend fun resourceArns(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceArns = mapped
    }

    /**
     * @param value Tag(s) the resources need to have to be considered a valid target for an action. Conflicts with `resource_arns`. See below.
     */
    @JvmName("ryghvvsjwpjoksle")
    public suspend fun resourceTags(`value`: List<ExperimentTemplateTargetResourceTagArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceTags = mapped
    }

    /**
     * @param argument Tag(s) the resources need to have to be considered a valid target for an action. Conflicts with `resource_arns`. See below.
     */
    @JvmName("brdgfgevphragvti")
    public suspend fun resourceTags(argument: List<suspend ExperimentTemplateTargetResourceTagArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ExperimentTemplateTargetResourceTagArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.resourceTags = mapped
    }

    /**
     * @param argument Tag(s) the resources need to have to be considered a valid target for an action. Conflicts with `resource_arns`. See below.
     */
    @JvmName("paoqnqjgoxvtfeof")
    public suspend fun resourceTags(vararg argument: suspend ExperimentTemplateTargetResourceTagArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ExperimentTemplateTargetResourceTagArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.resourceTags = mapped
    }

    /**
     * @param argument Tag(s) the resources need to have to be considered a valid target for an action. Conflicts with `resource_arns`. See below.
     */
    @JvmName("iehghuwsxwmwixus")
    public suspend fun resourceTags(argument: suspend ExperimentTemplateTargetResourceTagArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ExperimentTemplateTargetResourceTagArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.resourceTags = mapped
    }

    /**
     * @param values Tag(s) the resources need to have to be considered a valid target for an action. Conflicts with `resource_arns`. See below.
     */
    @JvmName("hwyrnascwawljcli")
    public suspend fun resourceTags(vararg values: ExperimentTemplateTargetResourceTagArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceTags = mapped
    }

    /**
     * @param value AWS resource type. The resource type must be supported for the specified action. To find out what resource types are supported, see [Targets for AWS FIS](https://docs.aws.amazon.com/fis/latest/userguide/targets.html#resource-types).
     */
    @JvmName("arxbjvwyustpxxmm")
    public suspend fun resourceType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceType = mapped
    }

    /**
     * @param value Scopes the identified resources. Valid values are `ALL` (all identified resources), `COUNT(n)` (randomly select `n` of the identified resources), `PERCENT(n)` (randomly select `n` percent of the identified resources).
     */
    @JvmName("drsdpjanboocrukm")
    public suspend fun selectionMode(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.selectionMode = mapped
    }

    internal fun build(): ExperimentTemplateTargetArgs = ExperimentTemplateTargetArgs(
        filters = filters,
        name = name ?: throw PulumiNullFieldException("name"),
        parameters = parameters,
        resourceArns = resourceArns,
        resourceTags = resourceTags,
        resourceType = resourceType ?: throw PulumiNullFieldException("resourceType"),
        selectionMode = selectionMode ?: throw PulumiNullFieldException("selectionMode"),
    )
}
