@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.fis.kotlin.inputs

import com.pulumi.aws.fis.inputs.ExperimentTemplateTargetResourceTagArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property key Tag key.
 * @property value Tag value.
 */
public data class ExperimentTemplateTargetResourceTagArgs(
    public val key: Output<String>,
    public val `value`: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.fis.inputs.ExperimentTemplateTargetResourceTagArgs> {
    override fun toJava(): com.pulumi.aws.fis.inputs.ExperimentTemplateTargetResourceTagArgs =
        com.pulumi.aws.fis.inputs.ExperimentTemplateTargetResourceTagArgs.builder()
            .key(key.applyValue({ args0 -> args0 }))
            .`value`(`value`.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ExperimentTemplateTargetResourceTagArgs].
 */
@PulumiTagMarker
public class ExperimentTemplateTargetResourceTagArgsBuilder internal constructor() {
    private var key: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value Tag key.
     */
    @JvmName("phfhiytwrddmiqki")
    public suspend fun key(`value`: Output<String>) {
        this.key = value
    }

    /**
     * @param value Tag value.
     */
    @JvmName("tbedditmfcyuonlx")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value Tag key.
     */
    @JvmName("vbibpvwjsysngxnu")
    public suspend fun key(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.key = mapped
    }

    /**
     * @param value Tag value.
     */
    @JvmName("fpkfgjuimxlklcit")
    public suspend fun `value`(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): ExperimentTemplateTargetResourceTagArgs =
        ExperimentTemplateTargetResourceTagArgs(
            key = key ?: throw PulumiNullFieldException("key"),
            `value` = `value` ?: throw PulumiNullFieldException("value"),
        )
}
