@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.fis.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property actionId ID of the action. To find out what actions are supported see [AWS FIS actions reference](https://docs.aws.amazon.com/fis/latest/userguide/fis-actions-reference.html).
 * @property description Description of the action.
 * @property name Friendly name of the action.
 * @property parameters Parameter(s) for the action, if applicable. See below.
 * @property startAfters Set of action names that must complete before this action can be executed.
 * @property target Action's target, if applicable. See below.
 */
public data class ExperimentTemplateAction(
    public val actionId: String,
    public val description: String? = null,
    public val name: String,
    public val parameters: List<ExperimentTemplateActionParameter>? = null,
    public val startAfters: List<String>? = null,
    public val target: ExperimentTemplateActionTarget? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.fis.outputs.ExperimentTemplateAction): ExperimentTemplateAction = ExperimentTemplateAction(
            actionId = javaType.actionId(),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            parameters = javaType.parameters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.fis.kotlin.outputs.ExperimentTemplateActionParameter.Companion.toKotlin(args0)
                })
            }),
            startAfters = javaType.startAfters().map({ args0 -> args0 }),
            target = javaType.target().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.fis.kotlin.outputs.ExperimentTemplateActionTarget.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
