@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.fis.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property key Parameter name.
 * @property value Parameter value.
 * For a list of parameters supported by each action, see [AWS FIS actions reference](https://docs.aws.amazon.com/fis/latest/userguide/fis-actions-reference.html).
 */
public data class ExperimentTemplateActionParameter(
    public val key: String,
    public val `value`: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.fis.outputs.ExperimentTemplateActionParameter): ExperimentTemplateActionParameter = ExperimentTemplateActionParameter(
            key = javaType.key(),
            `value` = javaType.`value`(),
        )
    }
}
