@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.fis.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property key Target type. Valid values are `AutoScalingGroups` (EC2 Auto Scaling groups), `Buckets` (S3 Buckets), `Cluster` (EKS Cluster), `Clusters` (ECS Clusters), `DBInstances` (RDS DB Instances), `Instances` (EC2 Instances), `Nodegroups` (EKS Node groups), `Pods` (EKS Pods), `ReplicationGroups`(ElastiCache Redis Replication Groups), `Roles` (IAM Roles), `SpotInstances` (EC2 Spot Instances), `Subnets` (VPC Subnets), `Tables` (DynamoDB encrypted global tables), `Tasks` (ECS Tasks), `TransitGateways` (Transit gateways), `Volumes` (EBS Volumes). See the [documentation](https://docs.aws.amazon.com/fis/latest/userguide/actions.html#action-targets) for more details.
 * @property value Target name, referencing a corresponding target.
 */
public data class ExperimentTemplateActionTarget(
    public val key: String,
    public val `value`: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.fis.outputs.ExperimentTemplateActionTarget): ExperimentTemplateActionTarget = ExperimentTemplateActionTarget(
            key = javaType.key(),
            `value` = javaType.`value`(),
        )
    }
}
