@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.fis.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property accountTargeting Specifies the account targeting setting for experiment options. Supports `single-account` and `multi-account`.
 * @property emptyTargetResolutionMode Specifies the empty target resolution mode for experiment options. Supports `fail` and `skip`.
 */
public data class ExperimentTemplateExperimentOptions(
    public val accountTargeting: String? = null,
    public val emptyTargetResolutionMode: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.fis.outputs.ExperimentTemplateExperimentOptions): ExperimentTemplateExperimentOptions = ExperimentTemplateExperimentOptions(
            accountTargeting = javaType.accountTargeting().map({ args0 -> args0 }).orElse(null),
            emptyTargetResolutionMode = javaType.emptyTargetResolutionMode().map({ args0 ->
                args0
            }).orElse(null),
        )
    }
}
