@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.fis.kotlin.outputs

import kotlin.Int
import kotlin.Suppress

/**
 *
 * @property cloudwatchLogsConfiguration The configuration for experiment logging to Amazon CloudWatch Logs. See below.
 * @property logSchemaVersion The schema version. See [documentation](https://docs.aws.amazon.com/fis/latest/userguide/monitoring-logging.html#experiment-log-schema) for the list of schema versions.
 * @property s3Configuration The configuration for experiment logging to Amazon S3. See below.
 */
public data class ExperimentTemplateLogConfiguration(
    public val cloudwatchLogsConfiguration: ExperimentTemplateLogConfigurationCloudwatchLogsConfiguration? = null,
    public val logSchemaVersion: Int,
    public val s3Configuration: ExperimentTemplateLogConfigurationS3Configuration? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.fis.outputs.ExperimentTemplateLogConfiguration): ExperimentTemplateLogConfiguration = ExperimentTemplateLogConfiguration(
            cloudwatchLogsConfiguration = javaType.cloudwatchLogsConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.fis.kotlin.outputs.ExperimentTemplateLogConfigurationCloudwatchLogsConfiguration.Companion.toKotlin(args0)
                })
            }).orElse(null),
            logSchemaVersion = javaType.logSchemaVersion(),
            s3Configuration = javaType.s3Configuration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.fis.kotlin.outputs.ExperimentTemplateLogConfigurationS3Configuration.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
