@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.fis.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property bucketName The name of the destination bucket.
 * @property prefix The bucket prefix.
 */
public data class ExperimentTemplateLogConfigurationS3Configuration(
    public val bucketName: String,
    public val prefix: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.fis.outputs.ExperimentTemplateLogConfigurationS3Configuration): ExperimentTemplateLogConfigurationS3Configuration =
            ExperimentTemplateLogConfigurationS3Configuration(
                bucketName = javaType.bucketName(),
                prefix = javaType.prefix().map({ args0 -> args0 }).orElse(null),
            )
    }
}
