@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.fis.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 *
 * @property filters Filter(s) for the target. Filters can be used to select resources based on specific attributes returned by the respective describe action of the resource type. For more information, see [Targets for AWS FIS](https://docs.aws.amazon.com/fis/latest/userguide/targets.html#target-filters). See below.
 * @property name Friendly name given to the target.
 * @property parameters The resource type parameters.
 * > **NOTE:** The `target` configuration block requires either `resource_arns` or `resource_tag`.
 * @property resourceArns Set of ARNs of the resources to target with an action. Conflicts with `resource_tag`.
 * @property resourceTags Tag(s) the resources need to have to be considered a valid target for an action. Conflicts with `resource_arns`. See below.
 * @property resourceType AWS resource type. The resource type must be supported for the specified action. To find out what resource types are supported, see [Targets for AWS FIS](https://docs.aws.amazon.com/fis/latest/userguide/targets.html#resource-types).
 * @property selectionMode Scopes the identified resources. Valid values are `ALL` (all identified resources), `COUNT(n)` (randomly select `n` of the identified resources), `PERCENT(n)` (randomly select `n` percent of the identified resources).
 */
public data class ExperimentTemplateTarget(
    public val filters: List<ExperimentTemplateTargetFilter>? = null,
    public val name: String,
    public val parameters: Map<String, String>? = null,
    public val resourceArns: List<String>? = null,
    public val resourceTags: List<ExperimentTemplateTargetResourceTag>? = null,
    public val resourceType: String,
    public val selectionMode: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.fis.outputs.ExperimentTemplateTarget): ExperimentTemplateTarget = ExperimentTemplateTarget(
            filters = javaType.filters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.fis.kotlin.outputs.ExperimentTemplateTargetFilter.Companion.toKotlin(args0)
                })
            }),
            name = javaType.name(),
            parameters = javaType.parameters().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            resourceArns = javaType.resourceArns().map({ args0 -> args0 }),
            resourceTags = javaType.resourceTags().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.fis.kotlin.outputs.ExperimentTemplateTargetResourceTag.Companion.toKotlin(args0)
                })
            }),
            resourceType = javaType.resourceType(),
            selectionMode = javaType.selectionMode(),
        )
    }
}
