@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.fms.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [AdminAccount].
 */
@PulumiTagMarker
public class AdminAccountResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AdminAccountArgs = AdminAccountArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AdminAccountArgsBuilder.() -> Unit) {
        val builder = AdminAccountArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): AdminAccount {
        val builtJavaResource = com.pulumi.aws.fms.AdminAccount(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return AdminAccount(builtJavaResource)
    }
}

/**
 * Provides a resource to associate/disassociate an AWS Firewall Manager administrator account. This operation must be performed in the `us-east-1` region.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.fms.AdminAccount("example", {});
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.fms.AdminAccount("example")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Fms.AdminAccount("example");
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/fms"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := fms.NewAdminAccount(ctx, "example", nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.fms.AdminAccount;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new AdminAccount("example");
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:fms:AdminAccount
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Firewall Manager administrator account association using the account ID. For example:
 * ```sh
 * $ pulumi import aws:fms/adminAccount:AdminAccount example 123456789012
 * ```
 */
public class AdminAccount internal constructor(
    override val javaResource: com.pulumi.aws.fms.AdminAccount,
) : KotlinCustomResource(javaResource, AdminAccountMapper) {
    /**
     * The AWS account ID to associate with AWS Firewall Manager as the AWS Firewall Manager administrator account. This can be an AWS Organizations master account or a member account. Defaults to the current account. Must be configured to perform drift detection.
     */
    public val accountId: Output<String>
        get() = javaResource.accountId().applyValue({ args0 -> args0 })
}

public object AdminAccountMapper : ResourceMapper<AdminAccount> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.fms.AdminAccount::class == javaResource::class

    override fun map(javaResource: Resource): AdminAccount = AdminAccount(
        javaResource as
            com.pulumi.aws.fms.AdminAccount,
    )
}

/**
 * @see [AdminAccount].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [AdminAccount].
 */
public suspend fun adminAccount(
    name: String,
    block: suspend AdminAccountResourceBuilder.() -> Unit,
): AdminAccount {
    val builder = AdminAccountResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [AdminAccount].
 * @param name The _unique_ name of the resulting resource.
 */
public fun adminAccount(name: String): AdminAccount {
    val builder = AdminAccountResourceBuilder()
    builder.name(name)
    return builder.build()
}
